/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.news;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.recommenders.internal.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.rcp.news.NewsNotificationPopup;
import org.eclipse.recommenders.internal.rcp.news.RssParser;
import org.eclipse.recommenders.net.Proxies;
import org.eclipse.recommenders.rcp.utils.Shells;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Urls;

public class CheckForProjectNewsJob
extends Job {
    private URI feed = Urls.toUri((URL)Urls.toUrl((String)"http://www.codetrails.com/blog/feed/planet-eclipse"));
    private IEclipsePreferences prefs;

    public CheckForProjectNewsJob(IEclipsePreferences prefs) {
        super(Messages.NEWS_LOADING_MESSAGE);
        this.setSystem(true);
        this.prefs = prefs;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.doRun();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARNING_EXCEPTION_PARSING_NEWS_FEED, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldRun() {
        boolean enabled = this.prefs.getBoolean("news-enabled", true);
        if (!enabled) {
            return false;
        }
        long time = this.prefs.getLong("news-last-check", 0L);
        Date last = new Date(time);
        Date now = new Date();
        Date pause = DateUtils.addDays((Date)last, (int)4);
        return !pause.after(now);
    }

    private void doRun() throws IOException {
        List<Pair<String, URL>> newsItems = this.getNewsItems((String)this.getRSSFeed().orNull());
        String link = this.createNotificationLink(newsItems);
        this.openPopup(link);
    }

    @VisibleForTesting
    protected List<Pair<String, URL>> getNewsItems(String rssFeed) {
        Date last = this.getLastRun();
        List<Pair<String, URL>> newsItems = RssParser.getEntries(rssFeed, last);
        this.saveLastRun();
        return newsItems;
    }

    @VisibleForTesting
    protected String createNotificationLink(List<Pair<String, URL>> entries) {
        if (entries.isEmpty()) {
            return "";
        }
        Pair<String, URL> latest = entries.get(0);
        String link = MessageFormat.format(Messages.NEWS_NOTIFY_MESSAGE, latest.getFirst(), latest.getSecond());
        return link;
    }

    private void openPopup(final String link) {
        if (Strings.isNullOrEmpty((String)link)) {
            return;
        }
        Shells.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                new NewsNotificationPopup(link).open();
            }
        });
    }

    private void saveLastRun() {
        this.prefs.putLong("news-last-check", new Date().getTime());
    }

    private Date getLastRun() {
        long time = this.prefs.getLong("news-last-check", System.currentTimeMillis());
        return new Date(time);
    }

    private Optional<String> getRSSFeed() throws IOException {
        Executor executor = Executor.newInstance();
        Request request = Request.Get((URI)this.feed).viaProxy((HttpHost)Proxies.getProxyHost((URI)this.feed).orNull());
        Response response = Proxies.proxyAuthentication((Executor)executor, (URI)this.feed).execute(request);
        HttpResponse httpResponse = response.returnResponse();
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        if (statusCode >= 400) {
            return Optional.absent();
        }
        HttpEntity entity = httpResponse.getEntity();
        return Optional.of((Object)IOUtils.toString((InputStream)entity.getContent(), (String)Charsets.UTF_8.name()));
    }
}

