/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.rcp.jdt;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.recommenders.testing.jdt.SimpleCompletionRequestor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.mockito.Mockito;

public class JavaContentAssistContextMock
extends JavaContentAssistInvocationContext {
    private final ICompilationUnit cu;
    private SimpleCompletionRequestor requestor;
    private final int completionOffset;

    public JavaContentAssistContextMock(ICompilationUnit cu, int completionOffset) throws JavaModelException {
        super(JavaContentAssistContextMock.createTextViewer(cu), completionOffset, (IEditorPart)Mockito.mock(IEditorPart.class));
        this.cu = cu;
        this.completionOffset = completionOffset;
        this.initializeCoreContext();
    }

    private static ITextViewer createTextViewer(ICompilationUnit cu) throws JavaModelException {
        ITextViewer mock = (ITextViewer)Mockito.mock(ITextViewer.class);
        Document document = new Document(cu.getSource());
        Mockito.when((Object)mock.getDocument()).thenReturn((Object)document);
        Mockito.when((Object)mock.getSelectedRange()).thenReturn((Object)new Point(-1, -1));
        return mock;
    }

    public CharSequence computeIdentifierPrefix() throws BadLocationException {
        char[] prefix = this.getCoreContext().getToken();
        if (prefix == null) {
            return "";
        }
        return String.valueOf(prefix);
    }

    private void initializeCoreContext() throws JavaModelException {
        this.requestor = new SimpleCompletionRequestor();
        try {
            this.cu.codeComplete(this.completionOffset, (CompletionRequestor)this.requestor);
        }
        catch (Exception exception) {
            String source = this.cu.getSource();
            int start = Math.max(0, 0);
            int end = Math.min(source.length(), this.completionOffset - 10);
            String location = String.valueOf(StringUtils.substring((String)source, (int)start, (int)this.completionOffset)) + "|<^space>" + StringUtils.substring((String)source, (int)this.completionOffset, (int)end);
            System.err.printf("error at completion offset %d: '%s'", this.completionOffset, location);
        }
    }

    public ICompilationUnit getCompilationUnit() {
        return this.cu;
    }

    public CompletionContext getCoreContext() {
        return this.requestor.context;
    }
}

