/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import java.util.Objects;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Throws;

public abstract class Result<T> {
    public static final int OK = 0;
    public static final int ABSENT = -1;

    public static <T> Result<T> of(T reference) {
        return new Present(Objects.requireNonNull(reference));
    }

    public static <T> Result<T> fromNullable(T nullableReference) {
        return nullableReference == null ? Result.absent() : new Present(nullableReference);
    }

    public static <T> Result<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Result<T> absent(int code) {
        return new AbsentWithReason(code, null);
    }

    public static <T> Result<T> absent(Throwable exception) {
        return new AbsentWithReason(0, exception);
    }

    public static <T> Result<T> absent(int code, Throwable exception) {
        return new AbsentWithReason(code, exception);
    }

    public abstract boolean isPresent();

    public abstract boolean hasReason();

    public abstract int getReason();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Result<Throwable> getException();

    private static final class Absent
    extends Result<Object> {
        private static final Absent INSTANCE = new Absent();

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean hasReason() {
            return false;
        }

        @Override
        public Object or(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public Object get() {
            throw Throws.throwIllegalStateException("cannot get() value from Absent");
        }

        @Override
        public int getReason() {
            return -1;
        }

        @Override
        public Result<Throwable> getException() {
            return Result.absent();
        }

        public String toString() {
            return "Result.absent()";
        }

        public boolean equals(Object that) {
            return this == that;
        }

        public int hashCode() {
            return 1502476572;
        }
    }

    private static final class AbsentWithReason
    extends Result<Object> {
        private final int reason;
        private final Throwable exception;

        private AbsentWithReason(int reason, Throwable exception) {
            Checks.ensureIsTrue(reason < -1 || reason > 0, "Reason must not be -1 or 0.", new Object[0]);
            this.reason = reason;
            this.exception = exception;
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public boolean hasReason() {
            return true;
        }

        @Override
        public Object or(Object defaultValue) {
            return defaultValue;
        }

        @Override
        public Object get() {
            throw Throws.throwIllegalStateException("cannot get() value from AbsentWithReason");
        }

        @Override
        public int getReason() {
            return this.reason;
        }

        @Override
        public Result<Throwable> getException() {
            return Result.fromNullable(this.exception);
        }

        public String toString() {
            return "Result.error(" + this.reason + ", " + this.exception + ")";
        }

        public boolean equals(Object other) {
            if (other instanceof AbsentWithReason) {
                AbsentWithReason that = (AbsentWithReason)other;
                return this.reason == that.reason && Objects.equals(this.exception, that.exception);
            }
            return false;
        }

        public int hashCode() {
            return 1502476572 + this.reason + (this.exception != null ? this.exception.hashCode() : 0);
        }
    }

    private static final class Present<T>
    extends Result<T> {
        private final T reference;

        private Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public boolean hasReason() {
            return false;
        }

        @Override
        public T or(T defaultValue) {
            return this.reference;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public int getReason() {
            return 0;
        }

        @Override
        public Result<Throwable> getException() {
            return Result.absent();
        }

        public String toString() {
            return "Result.of(" + this.reference + ")";
        }

        public boolean equals(Object other) {
            if (other instanceof Present) {
                Present that = (Present)other;
                return this.reference.equals(that.reference);
            }
            return false;
        }

        public int hashCode() {
            return 1502476572 + this.reference.hashCode();
        }
    }
}

