/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.apidocs;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class ClassSelfcallDirectives {
    private final String providerId = this.getClass().getSimpleName();
    private ITypeName type;
    private int numberOfSubclasses;
    private Map<IMethodName, Integer> calls;

    public static ClassSelfcallDirectives create(ITypeName type, int numberOfSubclasses, Map<IMethodName, Integer> selfcalls) {
        ClassSelfcallDirectives res = new ClassSelfcallDirectives();
        res.type = type;
        res.numberOfSubclasses = numberOfSubclasses;
        res.calls = selfcalls;
        res.validate();
        return res;
    }

    public ITypeName getType() {
        return this.type;
    }

    public int getNumberOfSubclasses() {
        return this.numberOfSubclasses;
    }

    public Map<IMethodName, Integer> getCalls() {
        return this.calls;
    }

    public void validate() {
        Checks.ensureIsTrue((boolean)"ClassSelfcallDirectives".equals(this.providerId));
        Objects.requireNonNull(this.type);
        Checks.ensureIsGreaterOrEqualTo((double)this.numberOfSubclasses, (double)1.0, null);
        Checks.ensureIsFalse((boolean)this.calls.isEmpty(), (String)"empty self-calls not allowed", (Object[])new Object[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }
}

