/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.subwords.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.codeassist.InternalCompletionContext;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.javadoc.HTMLTagCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.completion.rcp.CompletionContextKey;
import org.eclipse.recommenders.completion.rcp.CompletionContexts;
import org.eclipse.recommenders.completion.rcp.HtmlTagProposals;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.NoProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalCollectingCompletionRequestor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.internal.subwords.rcp.LCSS;
import org.eclipse.recommenders.internal.subwords.rcp.SubwordsRcpPreferences;
import org.eclipse.recommenders.internal.subwords.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Reflections;
import org.eclipse.recommenders.utils.rcp.TimeDelimitedProgressMonitor;
import org.eclipse.ui.IEditorPart;

public class SubwordsSessionProcessor
extends SessionProcessor {
    private static final long COMPLETION_TIME_OUT = TimeUnit.SECONDS.toMillis(5L);
    private static final int JAVADOC_TYPE_REF_HIGHLIGHT_ADJUSTMENT = "{@link ".length();
    private static final int SUBWORDS_RANGE_START = -9000;
    private static final int CAMEL_CASE_RANGE_START = -6000;
    private static final int IGNORE_CASE_RANGE_START = -3000;
    private static final int[] EMPTY_SEQUENCE = new int[0];
    private static final Field CORE_CONTEXT = (Field)Reflections.getDeclaredField(JavaContentAssistInvocationContext.class, (String)"fCoreContext").orNull();
    private static final Field CU = (Field)Reflections.getDeclaredField(JavaContentAssistInvocationContext.class, (String)"fCU").orNull();
    private static final Field CU_COMPUTED = (Field)Reflections.getDeclaredField(JavaContentAssistInvocationContext.class, (String)"fCUComputed").orNull();
    private final HTMLTagCompletionProposalComputer htmlTagProposalComputer = new HTMLTagCompletionProposalComputer();
    private final SubwordsRcpPreferences prefs;
    private int minPrefixLengthForTypes;

    @Inject
    public SubwordsSessionProcessor(SubwordsRcpPreferences prefs) {
        this.prefs = prefs;
    }

    public void initializeContext(IRecommendersCompletionContext recContext) {
        try {
            this.minPrefixLengthForTypes = this.prefs.minPrefixLengthForTypes;
            JavaContentAssistInvocationContext jdtContext = recContext.getJavaContext();
            ICompilationUnit cu = jdtContext.getCompilationUnit();
            int offset = jdtContext.getInvocationOffset();
            NoProposalCollectingCompletionRequestor collector = new NoProposalCollectingCompletionRequestor();
            cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(COMPLETION_TIME_OUT, TimeUnit.MILLISECONDS));
            InternalCompletionContext compContext = collector.getCoreContext();
            if (compContext == null) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_COMPLETION_CONTEXT_NOT_COLLECTED, (Object[])new Object[]{cu.getPath()});
                return;
            }
            CORE_CONTEXT.set(jdtContext, compContext);
            recContext.set(CompletionContextKey.INTERNAL_COMPLETIONCONTEXT, (Object)compContext);
            String prefix = this.getPrefix(jdtContext);
            int length = prefix.length();
            recContext.set(CompletionContextKey.COMPLETION_PREFIX, (Object)prefix);
            HashMap baseProposals = Maps.newHashMap();
            recContext.set(CompletionContextKey.JAVA_PROPOSALS, (Object)baseProposals);
            ASTNode completionNode = compContext.getCompletionNode();
            ASTNode completionNodeParent = compContext.getCompletionNodeParent();
            SortedSet<Integer> triggerlocations = this.computeTriggerLocations(offset, completionNode, completionNodeParent, length);
            HashSet sortkeys = Sets.newHashSet();
            Iterator iterator = triggerlocations.iterator();
            while (iterator.hasNext()) {
                int trigger = (Integer)iterator.next();
                Map<IJavaCompletionProposal, CompletionProposal> newProposals = this.getNewProposals(jdtContext, trigger);
                this.testAndInsertNewProposals(recContext, baseProposals, sortkeys, newProposals);
            }
            if (jdtContext instanceof JavadocContentAssistInvocationContext) {
                ITextViewer viewer = jdtContext.getViewer();
                IEditorPart editor = this.lookupEditor(cu);
                JavadocContentAssistInvocationContext newJdtContext = new JavadocContentAssistInvocationContext(viewer, offset - length, editor, 0);
                this.testAndInsertNewProposals(recContext, baseProposals, sortkeys, HtmlTagProposals.computeHtmlTagProposals((HTMLTagCompletionProposalComputer)this.htmlTagProposalComputer, (JavaContentAssistInvocationContext)newJdtContext));
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
    }

    private SortedSet<Integer> computeTriggerLocations(int offset, ASTNode completionNode, ASTNode completionNodeParent, int length) {
        TreeSet triggerlocations = Sets.newTreeSet((Comparator)Ordering.natural().reverse());
        int emptyPrefix = offset - length;
        int triggerOffset = Math.min(this.minPrefixLengthForTypes, length);
        triggerlocations.add(emptyPrefix + triggerOffset);
        triggerlocations.add(emptyPrefix);
        return triggerlocations;
    }

    private String getPrefix(JavaContentAssistInvocationContext jdtContext) throws BadLocationException {
        CharSequence prefix = jdtContext.computeIdentifierPrefix();
        return prefix == null ? "" : prefix.toString();
    }

    private Map<IJavaCompletionProposal, CompletionProposal> getNewProposals(JavaContentAssistInvocationContext originalContext, int triggerOffset) {
        if (triggerOffset < 0) {
            return Maps.newHashMap();
        }
        ICompilationUnit cu = originalContext.getCompilationUnit();
        ITextViewer viewer = originalContext.getViewer();
        IEditorPart editor = this.lookupEditor(cu);
        JavaContentAssistInvocationContext newJdtContext = new JavaContentAssistInvocationContext(viewer, triggerOffset, editor);
        this.setCompilationUnit(newJdtContext, cu);
        ProposalCollectingCompletionRequestor collector = this.computeProposals(cu, newJdtContext, triggerOffset);
        Map proposals = collector.getProposals();
        return proposals != null ? proposals : Maps.newHashMap();
    }

    private void setCompilationUnit(JavaContentAssistInvocationContext newJdtContext, ICompilationUnit cu) {
        if (Checks.anyIsNull((Object[])new Object[]{CU, CU_COMPUTED})) {
            return;
        }
        try {
            CU.set(newJdtContext, cu);
            CU_COMPUTED.set(newJdtContext, true);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
    }

    private void testAndInsertNewProposals(IRecommendersCompletionContext crContext, Map<IJavaCompletionProposal, CompletionProposal> baseProposals, Set<String> sortkeys, Map<IJavaCompletionProposal, CompletionProposal> newProposals) {
        for (Map.Entry<IJavaCompletionProposal, CompletionProposal> entry : newProposals.entrySet()) {
            IJavaCompletionProposal javaProposal = entry.getKey();
            CompletionProposal coreProposal = entry.getValue();
            String completionIdentifier = this.computeCompletionIdentifier(javaProposal, coreProposal);
            String completion = CompletionContexts.getPrefixMatchingArea((String)completionIdentifier);
            if (sortkeys.contains(completionIdentifier) || !LCSS.containsSubsequence(completion, crContext.getPrefix())) continue;
            baseProposals.put(javaProposal, coreProposal);
            sortkeys.add(completionIdentifier);
        }
    }

    private String computeCompletionIdentifier(IJavaCompletionProposal javaProposal, CompletionProposal coreProposal) {
        String completionIdentifier;
        if (javaProposal instanceof LazyJavaCompletionProposal && coreProposal != null) {
            switch (coreProposal.getKind()) {
                case 26: {
                    completionIdentifier = "" + coreProposal.getName() + ' ' + coreProposal.getSignature() + coreProposal.getDeclarationSignature();
                    break;
                }
                case 16: {
                    char[] signature = coreProposal.getSignature();
                    char[] simpleName = Signature.getSignatureSimpleName((char[])signature);
                    int indexOf = CharOperation.lastIndexOf((char)'.', (char[])simpleName);
                    simpleName = CharOperation.subarray((char[])simpleName, (int)(indexOf + 1), (int)simpleName.length);
                    completionIdentifier = simpleName + ' ' + signature + " javadoc";
                    break;
                }
                case 9: {
                    char[] signature = coreProposal.getSignature();
                    char[] simpleName = Signature.getSignatureSimpleName((char[])signature);
                    int indexOf = CharOperation.lastIndexOf((char)'.', (char[])simpleName);
                    simpleName = CharOperation.subarray((char[])simpleName, (int)(indexOf + 1), (int)simpleName.length);
                    completionIdentifier = "" + simpleName + ' ' + signature;
                    break;
                }
                case 8: {
                    completionIdentifier = new String(coreProposal.getDeclarationSignature());
                    break;
                }
                case 6: 
                case 12: 
                case 24: {
                    completionIdentifier = "" + coreProposal.getName() + ' ' + coreProposal.getSignature() + coreProposal.getDeclarationSignature();
                    break;
                }
                case 15: {
                    completionIdentifier = coreProposal.getName() + ' ' + coreProposal.getSignature() + coreProposal.getDeclarationSignature() + " javadoc";
                    break;
                }
                case 18: 
                case 19: 
                case 20: {
                    completionIdentifier = javaProposal.getDisplayString();
                    break;
                }
                default: {
                    completionIdentifier = javaProposal.getDisplayString();
                    Logs.log((Logs.ILogMessage)LogMessages.ERROR_UNEXPECTED_FALL_THROUGH, (Object[])new Object[]{coreProposal.getKind(), javaProposal.getClass()});
                    break;
                }
            }
        } else {
            completionIdentifier = javaProposal.getDisplayString();
        }
        return completionIdentifier;
    }

    public boolean startSession(IRecommendersCompletionContext crContext) {
        return true;
    }

    private ProposalCollectingCompletionRequestor computeProposals(ICompilationUnit cu, JavaContentAssistInvocationContext coreContext, int offset) {
        ProposalCollectingCompletionRequestor collector = new ProposalCollectingCompletionRequestor(coreContext);
        try {
            cu.codeComplete(offset, (CompletionRequestor)collector, (IProgressMonitor)new TimeDelimitedProgressMonitor(COMPLETION_TIME_OUT, TimeUnit.MILLISECONDS));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_EXCEPTION_DURING_CODE_COMPLETION, (Throwable)e);
        }
        return collector;
    }

    @VisibleForTesting
    protected IEditorPart lookupEditor(ICompilationUnit cu) {
        return EditorUtility.isOpenInEditor((Object)cu);
    }

    public void process(final IProcessableProposal proposal) {
        String completionIdentifier = this.computeCompletionIdentifier((IJavaCompletionProposal)proposal, (CompletionProposal)proposal.getCoreProposal().orNull());
        final String matchingArea = CompletionContexts.getPrefixMatchingArea((String)completionIdentifier);
        proposal.getProposalProcessorManager().addProcessor(new ProposalProcessor(){
            int[] bestSequence = SubwordsSessionProcessor.access$0();
            String prefix;

            public boolean isPrefix(String prefix) {
                if (this.prefix != prefix) {
                    this.prefix = prefix;
                    CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().orNull();
                    if (coreProposal != null && (coreProposal.getKind() == 25 || coreProposal.getKind() == 24)) {
                        int lastIndexOfDot = prefix.lastIndexOf(46);
                        this.bestSequence = LCSS.bestSubsequence(matchingArea, prefix.substring(lastIndexOfDot + 1));
                    } else {
                        int lastIndexOfHash = prefix.lastIndexOf(35);
                        this.bestSequence = lastIndexOfHash >= 0 ? LCSS.bestSubsequence(matchingArea, prefix.substring(lastIndexOfHash + 1)) : LCSS.bestSubsequence(matchingArea, prefix);
                    }
                }
                return prefix.isEmpty() || this.bestSequence.length > 0;
            }

            public void modifyDisplayString(StyledString displayString) {
                int highlightAdjustment;
                CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().orNull();
                if (coreProposal == null) {
                    highlightAdjustment = proposal instanceof JavaCompletionProposal && displayString.toString().startsWith("</") ? 2 : (proposal instanceof JavaCompletionProposal && displayString.toString().startsWith("<") ? 1 : 0);
                } else {
                    switch (coreProposal.getKind()) {
                        case 14: 
                        case 15: 
                        case 17: {
                            highlightAdjustment = displayString.toString().lastIndexOf(35) + 1;
                            break;
                        }
                        case 16: {
                            highlightAdjustment = JAVADOC_TYPE_REF_HIGHLIGHT_ADJUSTMENT;
                            break;
                        }
                        default: {
                            highlightAdjustment = 0;
                        }
                    }
                }
                int[] nArray = this.bestSequence;
                int n = this.bestSequence.length;
                int n2 = 0;
                while (n2 < n) {
                    int index = nArray[n2];
                    displayString.setStyle(index + highlightAdjustment, 1, StyledString.COUNTER_STYLER);
                    ++n2;
                }
            }

            public int modifyRelevance() {
                if (ArrayUtils.isEmpty((int[])this.bestSequence)) {
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    return 0;
                }
                int relevanceBoost = 0;
                if (SubwordsSessionProcessor.this.minPrefixLengthForTypes < this.prefix.length() && StringUtils.equalsIgnoreCase((CharSequence)matchingArea, (CharSequence)this.prefix)) {
                    relevanceBoost += 64;
                }
                if (StringUtils.startsWith((CharSequence)matchingArea, (CharSequence)this.prefix) && this.isFromJavaCompletionProposalComputer(proposal)) {
                    proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, null);
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                } else if (StringUtils.startsWithIgnoreCase((CharSequence)matchingArea, (CharSequence)this.prefix)) {
                    proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, null);
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)true);
                    relevanceBoost -= 3000;
                } else if (CharOperation.camelCaseMatch((char[])this.prefix.toCharArray(), (char[])matchingArea.toCharArray()) && this.isFromJavaCompletionProposalComputer(proposal)) {
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)false);
                    proposal.setTag((IProposalTag)ProposalTag.IS_CAMEL_CASE_MATCH, (Object)true);
                    relevanceBoost -= 6000;
                } else {
                    int score = LCSS.scoreSubsequence(this.bestSequence);
                    proposal.setTag((IProposalTag)ProposalTag.IS_PREFIX_MATCH, (Object)false);
                    proposal.setTag((IProposalTag)ProposalTag.SUBWORDS_SCORE, (Object)score);
                    relevanceBoost = -9000 + relevanceBoost + score;
                }
                return relevanceBoost;
            }

            private boolean isFromJavaCompletionProposalComputer(IProcessableProposal proposal2) {
                return proposal2.getCoreProposal().isPresent();
            }
        });
    }

    static /* synthetic */ int[] access$0() {
        return EMPTY_SEQUENCE;
    }
}

