/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.jdt;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Throws;
import org.junit.Assert;

public class JavaProjectFixture {
    public static final String JAVA_IDENTIFIER_REGEX = "([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*)";
    public static final IProgressMonitor NULL_PROGRESS_MONITOR = null;
    private IJavaProject javaProject;
    private ASTParser parser;

    public static String findClassName(CharSequence source) {
        Pattern p = Pattern.compile(".*?class\\s+([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*).*", 32);
        Matcher matcher = p.matcher(source);
        if (!matcher.matches()) {
            p = Pattern.compile(".*interface\\s+([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*).*", 32);
            matcher = p.matcher(source);
        }
        Assert.assertTrue((boolean)matcher.matches());
        return matcher.group(1);
    }

    public static List<String> findInnerClassNames(CharSequence source) {
        String declaringType = JavaProjectFixture.findClassName(source);
        ArrayList names = Lists.newArrayList();
        Pattern p = Pattern.compile("(class|interface)\\s+([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*)", 32);
        Matcher matcher = p.matcher(source);
        while (matcher.find()) {
            String name = matcher.group(2);
            if (name.equals(declaringType)) continue;
            names.add(String.valueOf(declaringType) + "$" + name);
        }
        return names;
    }

    public static List<String> findAnonymousClassNames(CharSequence source) {
        String declaringType = JavaProjectFixture.findClassName(source);
        int num = 1;
        ArrayList names = Lists.newArrayList();
        Pattern p = Pattern.compile("new\\s*?([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*)\\s*?\\([^)]*?\\)\\s*?\\{", 32);
        Matcher matcher = p.matcher(source);
        while (matcher.find()) {
            String name = matcher.group(1);
            if (name.equals(declaringType)) continue;
            names.add(String.valueOf(declaringType) + "$" + num++);
        }
        return names;
    }

    public static String findPackageName(CharSequence source) {
        Pattern p = Pattern.compile(".*package\\s+(([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*){1}([.]{1}([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*))*)[;]+.*", 32);
        Matcher matcher = p.matcher(source);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    public JavaProjectFixture(IWorkspace workspace, String projectName) {
        this.createJavaProject(workspace, projectName);
        this.createParser();
    }

    private void createJavaProject(IWorkspace workspace, String projectName) {
        final IProject project = workspace.getRoot().getProject(projectName);
        IWorkspaceRunnable populate = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                this.createAndOpenProject(project);
                if (!this.hasJavaNature(project)) {
                    this.addJavaNature(project);
                    this.configureProjectClasspath();
                }
            }

            private void createAndOpenProject(IProject project2) throws CoreException {
                if (!project2.exists()) {
                    project2.create(NULL_PROGRESS_MONITOR);
                }
                project2.open(NULL_PROGRESS_MONITOR);
            }

            private boolean hasJavaNature(IProject project2) throws CoreException {
                IProjectDescription description = project2.getDescription();
                Object[] natures = description.getNatureIds();
                return ArrayUtils.contains((Object[])natures, (Object)"org.eclipse.jdt.core.javanature");
            }

            private void configureProjectClasspath() throws JavaModelException {
                HashSet entries = Sets.newHashSet();
                IClasspathEntry[] rawClasspath = JavaProjectFixture.this.javaProject.getRawClasspath();
                IClasspathEntry defaultJREContainerEntry = JavaRuntime.getDefaultJREContainerEntry();
                entries.addAll(Arrays.asList(rawClasspath));
                entries.add(defaultJREContainerEntry);
                IClasspathEntry[] entriesArray = entries.toArray(new IClasspathEntry[entries.size()]);
                JavaProjectFixture.this.javaProject.setRawClasspath(entriesArray, NULL_PROGRESS_MONITOR);
            }

            private void addJavaNature(IProject project2) throws CoreException {
                IProjectDescription description = project2.getDescription();
                Object[] natures = description.getNatureIds();
                String[] newNatures = (String[])ArrayUtils.add((Object[])natures, (Object)"org.eclipse.jdt.core.javanature");
                description.setNatureIds(newNatures);
                project2.setDescription(description, NULL_PROGRESS_MONITOR);
                JavaProjectFixture.this.javaProject = JavaCore.create((IProject)project2);
            }
        };
        try {
            workspace.run(populate, NULL_PROGRESS_MONITOR);
        }
        catch (Exception e) {
            Throws.throwUnhandledException((Exception)e);
        }
        this.javaProject = JavaCore.create((IProject)project);
    }

    private void createParser() {
        this.parser = ASTParser.newParser((int)3);
        this.parser.setProject(this.javaProject);
        this.parser.setKind(8);
        this.parser.setResolveBindings(true);
    }

    public Pair<CompilationUnit, Set<Integer>> parseWithMarkers(String content) {
        Pair<String, Set<Integer>> contentMarkersPair = this.findMarkers(content);
        String contentWoMarkers = (String)contentMarkersPair.getFirst();
        Set markers = (Set)contentMarkersPair.getSecond();
        CompilationUnit cu = this.parse(contentWoMarkers);
        return Pair.newPair((Object)cu, (Object)markers);
    }

    public Pair<String, Set<Integer>> findMarkers(CharSequence content) {
        return this.findMarkers(content, "$");
    }

    public Pair<String, Set<Integer>> findMarkers(CharSequence content, String marker) {
        TreeSet markers = Sets.newTreeSet();
        int pos = 0;
        StringBuilder sb = new StringBuilder(content);
        while ((pos = sb.indexOf(marker, pos)) != -1) {
            sb.deleteCharAt(pos);
            markers.add(pos);
            Checks.ensureIsTrue((pos <= sb.length() ? 1 : 0) != 0);
            --pos;
        }
        return Pair.newPair((Object)sb.toString(), (Object)markers);
    }

    public CompilationUnit parse(String content) {
        this.parser.setSource(content.toCharArray());
        this.parser.setUnitName(String.valueOf(JavaProjectFixture.findClassName(content)) + ".java");
        return (CompilationUnit)Checks.cast((Object)this.parser.createAST(NULL_PROGRESS_MONITOR));
    }

    public Pair<ICompilationUnit, Set<Integer>> createFileAndParseWithMarkers(CharSequence contentWithMarkers) throws CoreException {
        return this.createFileAndParseWithMarkers(contentWithMarkers, "$");
    }

    public Pair<ICompilationUnit, Set<Integer>> createFileAndParseWithMarkers(CharSequence contentWithMarkers, String marker) throws CoreException {
        Pair<String, Set<Integer>> content = this.findMarkers(contentWithMarkers, marker);
        ICompilationUnit cu = this.createFile((String)content.getFirst(), false);
        this.refreshAndBuildProject();
        return Pair.newPair((Object)cu, (Object)((Set)content.getSecond()));
    }

    public Pair<ICompilationUnit, Set<Integer>> createFileAndPackageAndParseWithMarkers(CharSequence contentWithMarkers) throws CoreException {
        Pair<String, Set<Integer>> content = this.findMarkers(contentWithMarkers);
        this.createPackage((String)content.getFirst());
        ICompilationUnit cu = this.createFile((String)content.getFirst(), true);
        this.refreshAndBuildProject();
        return Pair.newPair((Object)cu, (Object)((Set)content.getSecond()));
    }

    public void refreshAndBuildProject() throws CoreException {
        IProject project = this.javaProject.getProject();
        project.refreshLocal(2, NULL_PROGRESS_MONITOR);
        project.build(6, NULL_PROGRESS_MONITOR);
    }

    public void createPackage(String content) throws CoreException {
        String packageName = JavaProjectFixture.findPackageName(content);
        if (!packageName.equalsIgnoreCase("")) {
            IProject project = this.javaProject.getProject();
            IPath projectPath = project.getLocation().addTrailingSeparator();
            String relativeFilePath = packageName.replace('.', '/');
            relativeFilePath = String.valueOf(relativeFilePath) + String.valueOf('/');
            Path packagePath = new Path(String.valueOf(projectPath.toString()) + relativeFilePath);
            File packageDirectory = packagePath.toFile();
            packageDirectory.mkdirs();
            project.refreshLocal(2, NULL_PROGRESS_MONITOR);
        }
    }

    public ICompilationUnit createFile(String content, boolean usePackage) throws CoreException {
        String packageName;
        IProject project = this.javaProject.getProject();
        String fileName = String.valueOf(JavaProjectFixture.findClassName(content)) + ".java";
        StringBuilder relativeFilePath = new StringBuilder();
        if (usePackage && !(packageName = JavaProjectFixture.findPackageName(content)).equalsIgnoreCase("")) {
            relativeFilePath.append(packageName.replace('.', '/'));
            relativeFilePath.append(String.valueOf('/'));
        }
        relativeFilePath.append(fileName);
        Path path = new Path(relativeFilePath.toString());
        IFile file = project.getFile((IPath)path);
        if (file.exists()) {
            file.delete(true, NULL_PROGRESS_MONITOR);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)is, true, NULL_PROGRESS_MONITOR);
        int attempts = 0;
        while (!file.exists()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            if (++attempts <= 10) continue;
            throw new IllegalStateException("Failed to create file");
        }
        ICompilationUnit cu = (ICompilationUnit)this.javaProject.findElement((IPath)path);
        while (cu == null) {
            cu = (ICompilationUnit)this.javaProject.findElement((IPath)path);
        }
        return cu;
    }

    public void clear() throws CoreException {
        IProject project = this.javaProject.getProject();
        project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                switch (resource.getType()) {
                    case 1: {
                        if (!resource.getName().endsWith(".class") && !resource.getName().endsWith(".java")) break;
                        resource.delete(true, NULL_PROGRESS_MONITOR);
                    }
                }
                return true;
            }
        });
    }

    public void deleteProject() throws CoreException {
        this.javaProject.getProject().delete(true, true, NULL_PROGRESS_MONITOR);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public String removeMarkers(String content) {
        return content.replaceAll("\\$", "");
    }
}

