/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jdt.templates;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.recommenders.internal.jdt.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public class SnippetCodeBuilder {
    private final CompilationUnit ast;
    private final ASTNode startNode;
    private final IDocument doc;
    private final IRegion textSelection;
    private final Set<String> imports = Sets.newTreeSet();
    private final Set<String> importStatics = Sets.newTreeSet();
    private final HashMap<IVariableBinding, String> vars = Maps.newHashMap();
    private final HashMap<String, Integer> lastVarIndex = Maps.newHashMap();
    private final StringBuilder sb = new StringBuilder();

    public SnippetCodeBuilder(CompilationUnit ast, IDocument doc, IRegion textSelection) {
        this(ast, (ASTNode)ast, doc, textSelection);
    }

    public SnippetCodeBuilder(ASTNode startNode, IDocument doc, IRegion textSelection) {
        this((CompilationUnit)startNode.getRoot(), startNode, doc, textSelection);
    }

    private SnippetCodeBuilder(CompilationUnit ast, ASTNode startNode, IDocument doc, IRegion textSelection) {
        this.ast = Objects.requireNonNull(ast);
        this.startNode = Objects.requireNonNull(startNode);
        this.doc = Objects.requireNonNull(doc);
        this.textSelection = Objects.requireNonNull(textSelection);
    }

    /*
     * Unable to fully structure code
     */
    public String build() {
        start = this.textSelection.getOffset();
        length = this.textSelection.getLength();
        try {
            text = this.doc.get(start, length);
        }
        catch (BadLocationException e) {
            javaElement = this.ast.getJavaElement();
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_GET_TEXT_SELECTION, (Throwable)e, (Object[])new Object[]{javaElement == null ? null : javaElement.getHandleIdentifier(), start, length});
            return "";
        }
        if (text == null) {
            javaElement = this.ast.getJavaElement();
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_GET_TEXT_SELECTION, (Object[])new Object[]{javaElement == null ? null : javaElement.getHandleIdentifier(), start, length});
            return "";
        }
        chars = text.toCharArray();
        enclosingNode = NodeFinder.perform((ASTNode)this.startNode, (int)start, (int)length);
        i = 0;
        while (i < chars.length) {
            block28: {
                block27: {
                    c = chars[i];
                    if (Character.isJavaIdentifierPart(c)) break block27;
                    this.sb.append(c);
                    break block28;
                }
                nodeFinder = new NodeFinder(enclosingNode, start + i, 0);
                node = nodeFinder.getCoveringNode();
                if (!this.isCoveredBySelection(node)) ** GOTO lbl-1000
                block1 : switch (node.getNodeType()) {
                    case 42: {
                        name = (SimpleName)node;
                        b = name.resolveBinding();
                        if (b != null) {
                            switch (b.getKind()) {
                                case 2: {
                                    this.sb.append(name);
                                    if (!this.isQualified(name) && !this.isDeclaredInSelection(b)) {
                                        this.rememberImport((ITypeBinding)b);
                                    }
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                                case 4: {
                                    this.sb.append(name);
                                    if (this.isUnqualifiedMethodInvocation(name) && this.isStatic(b) && !this.isDeclaredInSelection(b)) {
                                        this.rememberStaticImport((IMethodBinding)b);
                                    }
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                                case 3: {
                                    vb = (IVariableBinding)b;
                                    uniqueVariableName = this.generateUniqueVariableName(vb, StringUtils.remove((String)name.toString(), (char)'$'));
                                    if (this.isDeclaration(name)) {
                                        if (!this.appendNewNameVariable(uniqueVariableName, vb)) {
                                            this.sb.append(name);
                                        }
                                    } else if (this.isDeclaredInSelection((IBinding)vb)) {
                                        this.appendVariableReference(uniqueVariableName);
                                    } else if (this.isQualified(name)) {
                                        this.sb.append(name);
                                    } else if (vb.isField()) {
                                        if (this.isStatic((IBinding)vb)) {
                                            this.sb.append(name);
                                            this.rememberStaticImport(vb);
                                        } else if (!this.appendFieldVariable(uniqueVariableName, vb)) {
                                            this.sb.append(name);
                                        }
                                    } else {
                                        this.appendVarVariable(uniqueVariableName, vb);
                                    }
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                            }
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.sb.append(c);
                        if (c != '$') break;
                        this.sb.append(c);
                    }
                }
            }
            ++i;
        }
        this.sb.append('\n');
        this.appendImportVariable();
        this.appendImportStaticVariable();
        this.appendCursorVariable();
        this.replaceLeadingWhitespaces();
        return this.sb.toString();
    }

    public boolean isCoveredBySelection(ASTNode node) {
        int nodeStart = node.getStartPosition();
        int nodeEnd = nodeStart + node.getLength();
        return this.textSelection.getOffset() <= nodeStart && nodeEnd <= this.textSelection.getOffset() + this.textSelection.getLength();
    }

    private boolean isDeclaredInSelection(IBinding binding) {
        ASTNode declaringNode = this.ast.findDeclaringNode(binding);
        if (declaringNode == null) {
            return false;
        }
        return this.isCoveredBySelection(declaringNode);
    }

    private boolean isQualified(SimpleName name) {
        return QualifiedName.NAME_PROPERTY.equals(name.getLocationInParent());
    }

    private boolean isUnqualifiedMethodInvocation(SimpleName name) {
        if (!MethodInvocation.NAME_PROPERTY.equals(name.getLocationInParent())) {
            return false;
        }
        MethodInvocation methodInvocation = (MethodInvocation)name.getParent();
        return methodInvocation.getExpression() == null;
    }

    private boolean isStatic(IBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private boolean isDeclaration(SimpleName name) {
        if (VariableDeclarationFragment.NAME_PROPERTY.equals(name.getLocationInParent())) {
            return true;
        }
        return SingleVariableDeclaration.NAME_PROPERTY.equals(name.getLocationInParent());
    }

    private void rememberImport(ITypeBinding binding) {
        if (binding.isArray()) {
            this.rememberImport(binding.getComponentType());
            return;
        }
        IPackageBinding packageBinding = binding.getPackage();
        if (packageBinding == null) {
            return;
        }
        if (packageBinding.isUnnamed()) {
            return;
        }
        if (packageBinding.getName().equals("java.lang")) {
            return;
        }
        this.imports.add(binding.getErasure().getQualifiedName());
    }

    private void rememberStaticImport(IMethodBinding method) {
        Preconditions.checkArgument((boolean)this.isStatic((IBinding)method));
        this.rememberStaticImport(method.getDeclaringClass(), method.getName());
    }

    private void rememberStaticImport(IVariableBinding field) {
        Preconditions.checkArgument((boolean)field.isField());
        Preconditions.checkArgument((boolean)this.isStatic((IBinding)field));
        this.rememberStaticImport(field.getDeclaringClass(), field.getName());
    }

    private void rememberStaticImport(ITypeBinding declaringClass, String member) {
        if (declaringClass == null) {
            return;
        }
        IPackageBinding packageBinding = declaringClass.getPackage();
        if (packageBinding == null) {
            return;
        }
        if (packageBinding.isUnnamed()) {
            return;
        }
        this.importStatics.add(String.valueOf(declaringClass.getErasure().getQualifiedName()) + '.' + member);
    }

    private String generateUniqueVariableName(IVariableBinding binding, String name) {
        if (binding != null && this.vars.containsKey(binding)) {
            return this.vars.get(binding);
        }
        String newName = name;
        Integer i = this.lastVarIndex.containsKey(newName) ? this.lastVarIndex.get(newName) : Integer.valueOf(1);
        while (this.vars.containsValue(newName)) {
            i = i + 1;
            newName = name.concat(i.toString());
        }
        this.lastVarIndex.put(name, i);
        this.vars.put(binding, newName);
        return newName;
    }

    private boolean appendNewNameVariable(String name, IVariableBinding binding) {
        return this.appendVarVariableInternal("newName", name, binding);
    }

    private boolean appendVariableReference(String name) {
        this.sb.append('$').append('{').append(name).append('}');
        return true;
    }

    private boolean appendFieldVariable(String name, IVariableBinding binding) {
        Preconditions.checkArgument((boolean)binding.isField());
        return this.appendVarVariableInternal("field", name, binding);
    }

    private boolean appendVarVariable(String name, IVariableBinding binding) {
        return this.appendVarVariableInternal("var", name, binding);
    }

    private boolean appendVarVariableInternal(String kind, String name, IVariableBinding binding) {
        ITypeBinding type = binding.getType();
        if (type == null) {
            return false;
        }
        ITypeBinding erasure = type.getErasure();
        if (erasure == null) {
            return false;
        }
        this.sb.append('$').append('{').append(name).append(':').append(kind).append('(');
        if (type.isArray()) {
            this.sb.append('\'').append(erasure.getQualifiedName()).append('\'');
        } else {
            this.sb.append(erasure.getQualifiedName());
        }
        this.sb.append(')').append('}');
        return true;
    }

    private boolean appendImportVariable() {
        return this.appendImportVariableInternal("import", this.imports);
    }

    private boolean appendImportStaticVariable() {
        return this.appendImportVariableInternal("importStatic", this.importStatics);
    }

    private boolean appendImportVariableInternal(String name, Collection<String> imports) {
        if (imports.isEmpty()) {
            return false;
        }
        String uniqueName = this.generateUniqueVariableName(null, name);
        String joinedImports = Joiner.on((String)", ").join(imports);
        this.sb.append('$').append('{').append(uniqueName).append(':').append(name).append('(').append(joinedImports).append(')').append('}');
        return true;
    }

    private void appendCursorVariable() {
        this.sb.append("${cursor}");
    }

    private void replaceLeadingWhitespaces() {
        try {
            IRegion firstLineInfo = this.doc.getLineInformationOfOffset(this.textSelection.getOffset());
            String line = this.doc.get(firstLineInfo.getOffset(), firstLineInfo.getLength());
            int index = 0;
            while (index < line.length()) {
                if (!Character.isWhitespace(line.charAt(index))) break;
                ++index;
            }
            String wsPrefix = line.substring(0, index);
            String[] code = this.sb.toString().split("\\r?\\n");
            this.sb.setLength(0);
            String[] stringArray = code;
            int n = code.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String clean = StringUtils.removeStart((String)l, (String)wsPrefix);
                this.sb.append(clean).append(SystemUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SNIPPET_REPLACE_LEADING_WHITESPACE_FAILED, (Throwable)e);
        }
    }
}

