/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import java.net.URL;
import org.eclipse.recommenders.internal.utils.rcp.BrowserDialog;
import org.eclipse.recommenders.internal.utils.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public final class Browsers {
    private Browsers() {
    }

    public static void openInDefaultBrowser(String url) {
        try {
            IWebBrowser defaultBrowser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            defaultBrowser.openURL(new URL(url));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_OPEN_BROWSER, (Throwable)e, (Object[])new Object[]{url});
        }
    }

    public static void openInDefaultBrowser(URL url) {
        Browsers.openInDefaultBrowser(url.toExternalForm());
    }

    public static void openInExternalBrowser(String url) {
        block2: {
            try {
                IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                externalBrowser.openURL(new URL(url));
            }
            catch (Exception exception) {
                if (Program.launch((String)url)) break block2;
                Browsers.openInDefaultBrowser(url);
            }
        }
    }

    public static void openInExternalBrowser(URL url) {
        Browsers.openInExternalBrowser(url.toExternalForm());
    }

    public static void addOpenBrowserAction(Link link) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browsers.openInExternalBrowser(event.text);
            }
        });
    }

    public static void openInDialogBrowser(String url) {
        BrowserDialog browserDialog = new BrowserDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), url);
        browserDialog.open();
    }

    public static void openInDialogBrowser(String url, int width, int height) {
        BrowserDialog browserDialog = new BrowserDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), url, width, height);
        browserDialog.open();
    }

    public static void openInDialogBrowser(URL url) {
        Browsers.openInDialogBrowser(url.toExternalForm());
    }
}

