/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.tips;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.tips.ICompletionTipProposal;
import org.eclipse.recommenders.internal.completion.rcp.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.osgi.service.prefs.BackingStoreException;

public class TipsSessionProcessor
extends SessionProcessor {
    private static final String PREF_NODE_ID_TIPS = "org.eclipse.recommenders.completion.rcp";
    private static final String SEEN = "completion_tips_seen";
    private static final String COMPLETION_TIP_ID = "id";
    private static final String COMPLETION_TIP_CLASS = "class";
    private final Map<ICompletionTipProposal, String> unseenTips = Maps.newHashMap();
    private final HashSet<String> seenTips;
    private IRecommendersCompletionContext context;
    private boolean tipsSeen;

    public TipsSessionProcessor() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.recommenders.completion.rcp.tips");
        Iterable split = Splitter.on((char)':').omitEmptyStrings().split((CharSequence)TipsSessionProcessor.getTipsPreferences().get(SEEN, ""));
        this.seenTips = Sets.newHashSet((Iterable)split);
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String id = element.getAttribute(COMPLETION_TIP_ID);
            if (!this.seenTips.contains(id)) {
                try {
                    ICompletionTipProposal proposal = (ICompletionTipProposal)element.createExecutableExtension(COMPLETION_TIP_CLASS);
                    this.unseenTips.put(proposal, id);
                }
                catch (CoreException e) {
                    Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_INSTANTIATE_COMPLETION_TIP, (Throwable)e);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean startSession(IRecommendersCompletionContext context) {
        this.context = context;
        if (this.unseenTips.isEmpty()) {
            return false;
        }
        if (this.preventsAutoComplete(context)) {
            return false;
        }
        for (ICompletionTipProposal tip : this.unseenTips.keySet()) {
            tip.setCursorPosition(context.getInvocationOffset());
        }
        return true;
    }

    private boolean preventsAutoComplete(IRecommendersCompletionContext context) {
        return context.getProposals().size() <= 1;
    }

    @Override
    public void endSession(List<ICompletionProposal> proposals) {
        proposals.addAll(Collections2.filter(this.unseenTips.keySet(), (Predicate)new Predicate<ICompletionTipProposal>(){

            public boolean apply(ICompletionTipProposal input) {
                return input.isApplicable(TipsSessionProcessor.this.context);
            }
        }));
        this.tipsSeen = false;
    }

    @Override
    public void selected(ICompletionProposal proposal) {
        if (this.unseenTips.containsKey(proposal)) {
            String id = this.unseenTips.remove(proposal);
            this.seenTips.add(id);
            this.tipsSeen = true;
        }
    }

    @Override
    public void aboutToClose() {
        if (this.tipsSeen) {
            TipsSessionProcessor.persistSeenTips(this.seenTips);
        }
    }

    private static void persistSeenTips(Set<String> seenTips) {
        String joined = Joiner.on((char)':').join(seenTips);
        IEclipsePreferences store = TipsSessionProcessor.getTipsPreferences();
        store.put(SEEN, joined);
        try {
            store.flush();
        }
        catch (BackingStoreException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_FLUSH_PREFERENCES, (Throwable)e);
        }
    }

    private static IEclipsePreferences getTipsPreferences() {
        return InstanceScope.INSTANCE.getNode(PREF_NODE_ID_TIPS);
    }
}

