/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Throws;

public final class Fingerprints {
    private Fingerprints() {
    }

    public static String sha1(File file) {
        return Fingerprints.hashFile(file, Hashing.sha1());
    }

    public static String md5(File file) {
        return Fingerprints.hashFile(file, Hashing.md5());
    }

    public static String sha1(String message) {
        return Fingerprints.hashString(message, Hashing.sha1());
    }

    public static String md5(String message) {
        return Fingerprints.hashString(message, Hashing.md5());
    }

    public static String sha1(InputStream stream) {
        return Fingerprints.hashStream(stream, Hashing.sha1());
    }

    public static String md5(InputStream stream) {
        return Fingerprints.hashStream(stream, Hashing.md5());
    }

    private static String hashFile(File file, HashFunction hashFunction) {
        Checks.ensureIsNotNull(file);
        Checks.ensureExists(file);
        Checks.ensureIsFile(file);
        try {
            return Files.hash((File)file, (HashFunction)hashFunction).toString();
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
    }

    private static String hashString(String message, HashFunction hashFunction) {
        Checks.ensureIsNotNull(message);
        HashCode hash = hashFunction.hashString((CharSequence)message, StandardCharsets.UTF_8);
        return hash.toString();
    }

    private static String hashStream(InputStream stream, HashFunction hashFunction) {
        Checks.ensureIsNotNull(stream);
        try {
            StreamInputSupplier supplier = new StreamInputSupplier(stream);
            HashCode hash = ByteStreams.hash((InputSupplier)supplier, (HashFunction)hashFunction);
            String string = hash.toString();
            return string;
        }
        catch (Exception e) {
            throw Throws.throwUnhandledException(e);
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private static final class StreamInputSupplier
    implements InputSupplier<InputStream> {
        private final InputStream stream;

        private StreamInputSupplier(InputStream stream) {
            this.stream = stream;
        }

        public InputStream getInput() throws IOException {
            return this.stream;
        }
    }
}

