/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Singleton;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;
import org.eclipse.recommenders.news.rcp.INewsProperties;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class NewsProperties
implements INewsProperties {
    private static final String FILENAME_READ_MESSAGES = "read-messages.properties";
    private static final String VALUE_READ = "read";
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private final File readMessagesFile;
    private final File pollDatesFile;
    private final File feedDatesFile;

    public NewsProperties() {
        this(NewsProperties.getFile(FILENAME_READ_MESSAGES), NewsProperties.getFile("poll-dates.properties"), NewsProperties.getFile("feed-dates.properties"));
    }

    @VisibleForTesting
    protected NewsProperties(File readMessagesFile, File pollDatesFile, File feedDatesFile) {
        this.readMessagesFile = readMessagesFile;
        this.pollDatesFile = pollDatesFile;
        this.feedDatesFile = feedDatesFile;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeReadIds(Set<String> readIds) {
        Properties properties = new Properties();
        if (readIds == null) {
            return;
        }
        for (String string : readIds) {
            properties.put(string, VALUE_READ);
        }
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (FileOutputStream stream = new FileOutputStream(this.readMessagesFile);){
                properties.store(stream, "");
            }
            catch (Throwable throwable2) {
                void var3_9;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var3_9;
            }
        }
        catch (IOException iOException) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_WRITING_PROPERTIES, iOException, FILENAME_READ_MESSAGES);
        }
    }

    @Override
    public Set<String> getReadIds() {
        if (!this.readMessagesFile.exists()) {
            return Sets.newConcurrentHashSet();
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = Files.asByteSource((File)this.readMessagesFile).openStream();){
                properties.load(stream);
                return Sets.newConcurrentHashSet(properties.stringPropertyNames());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_READING_PROPERTIES, e, FILENAME_READ_MESSAGES);
            return Sets.newConcurrentHashSet();
        }
    }

    private static File getFile(String name) {
        Bundle bundle = FrameworkUtil.getBundle(NewsProperties.class);
        File stateLocation = Platform.getStateLocation((Bundle)bundle).toFile();
        return new File(stateLocation, name);
    }

    @Override
    public Map<String, Date> getDates(String filename) {
        ConcurrentMap result = Maps.newConcurrentMap();
        File file = null;
        file = filename.equals("feed-dates.properties") ? this.feedDatesFile : this.pollDatesFile;
        if (!file.exists()) {
            return result;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = Files.asByteSource((File)file).openStream();){
                properties.load(stream);
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    result.put(entry.getKey().toString(), this.dateFormat.parse((String)entry.getValue()));
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParseException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_READING_PROPERTIES, e, filename);
            return result;
        }
    }

    @Override
    public void writeDates(Map<FeedDescriptor, Date> map, String filename) {
        if (map == null) {
            return;
        }
        Properties properties = new Properties();
        File file = null;
        file = filename.equals("feed-dates.properties") ? this.feedDatesFile : this.pollDatesFile;
        if (file.exists()) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream stream = Files.asByteSource((File)file).openStream();){
                    properties.load(stream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_READING_PROPERTIES, e, filename);
            }
        }
        ArrayList<?> propertyNames = Collections.list(properties.propertyNames());
        for (Map.Entry<FeedDescriptor, Date> entry : map.entrySet()) {
            if (!propertyNames.contains(entry.getKey().getId())) {
                properties.put(((FeedDescriptor)entry.getKey()).getId(), this.dateFormat.format((Date)entry.getValue()));
                continue;
            }
            properties.setProperty(((FeedDescriptor)entry.getKey()).getId(), this.dateFormat.format((Date)entry.getValue()));
        }
        try {
            Map.Entry<FeedDescriptor, Date> entry;
            entry = null;
            Iterator<Map.Entry<FeedDescriptor, Date>> iterator = null;
            try (FileOutputStream stream = new FileOutputStream(file);){
                properties.store(stream, "");
            }
            catch (Throwable throwable) {
                if (entry == null) {
                    entry = throwable;
                } else if (entry != throwable) {
                    ((Throwable)((Object)entry)).addSuppressed(throwable);
                }
                throw entry;
            }
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_WRITING_PROPERTIES, filename, e);
        }
    }
}

