/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.collect.Maps;
import com.google.common.eventbus.Subscribe;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.recommenders.internal.news.rcp.CommonImages;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedEvents;
import org.eclipse.recommenders.internal.news.rcp.MessageUtils;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpModule;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.internal.news.rcp.PollingResult;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.menus.NewsMenuListener;
import org.eclipse.recommenders.news.rcp.INewsService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;

@Creatable
public class NewsToolbarContribution
extends WorkbenchWindowControlContribution {
    @Inject
    private INewsService service;
    @Inject
    private NewsRcpPreferences preferences;
    private NewsMenuListener newsMenuListener;
    private UpdatingNewsAction updatingNewsAction;
    private MenuManager menuManager;

    public NewsToolbarContribution() {
        NewsRcpModule.initiateContext((Object)this);
    }

    @PostConstruct
    public void init() {
        NewsRcpModule.EVENT_BUS.register((Object)this);
        this.newsMenuListener = new NewsMenuListener(NewsRcpModule.EVENT_BUS, this.service);
    }

    protected Control createControl(Composite parent) {
        this.menuManager = new MenuManager();
        this.updatingNewsAction = new UpdatingNewsAction();
        ToolBarManager manager = new ToolBarManager(0x800100);
        manager.add((IAction)this.updatingNewsAction);
        manager.setContextMenuManager(this.menuManager);
        return manager.createControl(parent);
    }

    @Subscribe
    public void handle(FeedEvents.NewFeedItemsEvent event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench.isClosing()) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                NewsToolbarContribution.this.updatingNewsAction.setAvailableNews();
            }
        });
    }

    @Subscribe
    public void handleAllRead(FeedEvents.AllReadEvent event) {
        this.updatingNewsAction.checkForNews();
    }

    @Subscribe
    public void handleFeedRead(FeedEvents.FeedReadEvent event) {
        this.updatingNewsAction.checkForNews();
    }

    @Subscribe
    public void handleMessageRead(FeedEvents.FeedMessageReadEvent event) {
        this.updatingNewsAction.checkForNews();
    }

    private class UpdatingNewsAction
    extends Action {
        Map<FeedDescriptor, PollingResult> messages = Maps.newHashMap();

        private UpdatingNewsAction() {
            this.setNoAvailableNews();
        }

        public void run() {
            this.setNoAvailableNews();
            this.messages = NewsToolbarContribution.this.service.getMessages(20);
            NewsToolbarContribution.this.menuManager.getMenu().setVisible(true);
            if (!this.messages.isEmpty() || MessageUtils.containsUnreadMessages(this.messages)) {
                this.setAvailableNews();
            }
        }

        private void setNoAvailableNews() {
            this.setImageDescriptor(CommonImages.RSS_INACTIVE);
            this.setToolTipText(Messages.TOOLTIP_NO_NEW_MESSAGES);
            this.clearMenu();
            HashMap groupedMessages = Maps.newHashMap();
            for (FeedDescriptor feed : NewsToolbarContribution.this.preferences.getFeedDescriptors()) {
                groupedMessages.put(feed, new PollingResult(PollingResult.Status.FEEDS_NOT_POLLED_YET));
            }
            NewsToolbarContribution.this.newsMenuListener.setMessages(groupedMessages);
            NewsToolbarContribution.this.menuManager.addMenuListener((IMenuListener)NewsToolbarContribution.this.newsMenuListener);
        }

        private void setAvailableNews() {
            this.messages = NewsToolbarContribution.this.service.getMessages(20);
            if (!MessageUtils.containsUnreadMessages(this.messages)) {
                this.setImageDescriptor(CommonImages.RSS_INACTIVE);
            } else {
                this.setImageDescriptor(CommonImages.RSS_ACTIVE);
            }
            this.setToolTipText(MessageFormat.format(Messages.TOOLTIP_NEW_MESSAGES, MessageUtils.getUnreadMessagesNumber(MessageUtils.mergeMessages(this.messages))));
            this.clearMenu();
            this.setNewsMenu(this.messages);
        }

        private void clearMenu() {
            NewsToolbarContribution.this.menuManager.setRemoveAllWhenShown(true);
            NewsToolbarContribution.this.menuManager.removeMenuListener((IMenuListener)NewsToolbarContribution.this.newsMenuListener);
        }

        private void setNewsMenu(Map<FeedDescriptor, PollingResult> messages) {
            NewsToolbarContribution.this.newsMenuListener.setMessages(messages);
            NewsToolbarContribution.this.menuManager.addMenuListener((IMenuListener)NewsToolbarContribution.this.newsMenuListener);
        }

        public void checkForNews() {
            this.messages = NewsToolbarContribution.this.service.getMessages(20);
            if (this.messages.isEmpty() || !MessageUtils.containsUnreadMessages(this.messages)) {
                this.setNoAvailableNews();
            }
        }
    }
}

