/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.recommenders.news.rcp.IFeedMessage;

public class PollingResult {
    private final Status status;
    private final List<IFeedMessage> messages;

    public PollingResult(Status status, List<IFeedMessage> messages) {
        this.status = status;
        this.messages = Lists.newArrayList(messages);
    }

    public PollingResult(Status status) {
        this.status = status;
        this.messages = Lists.newArrayList();
    }

    public Status getStatus() {
        return this.status;
    }

    public List<IFeedMessage> getMessages() {
        return this.messages;
    }

    public static PollingResult newConnectionErrorResult() {
        return new PollingResult(Status.ERROR_CONNECTING_TO_FEED, new ArrayList<IFeedMessage>());
    }

    public static enum Status {
        OK,
        FEEDS_NOT_POLLED_YET,
        FEED_NOT_FOUND_AT_URL,
        ERROR_CONNECTING_TO_FEED;

    }
}

