/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.notifications;

import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.recommenders.internal.news.rcp.BrowserUtils;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedEvents;
import org.eclipse.recommenders.internal.news.rcp.MessageUtils;
import org.eclipse.recommenders.internal.news.rcp.PollingResult;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.notifications.AbstractNotificationPopup;
import org.eclipse.recommenders.internal.news.rcp.notifications.CommonFonts;
import org.eclipse.recommenders.news.rcp.IFeedMessage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class NewsNotificationPopup
extends AbstractNotificationPopup {
    private static final int DELAY_CLOSE_MS = 4000;
    private static final int DEFAULT_NOTIFICATION_MESSAGES = 6;
    private final Map<FeedDescriptor, PollingResult> messages;
    private final EventBus eventBus;

    public NewsNotificationPopup(Display display, Map<FeedDescriptor, PollingResult> messages, EventBus eventBus) {
        super(display);
        this.messages = messages;
        this.eventBus = eventBus;
        this.setFadingEnabled(true);
        this.setDelayClose(4000L);
    }

    @Override
    protected void createContentArea(Composite composite) {
        super.createContentArea(composite);
        composite.setLayout((Layout)new GridLayout(1, true));
        Map<FeedDescriptor, PollingResult> sortedMap = MessageUtils.sortByDate(this.messages);
        this.processNotificationData(composite, sortedMap);
        Label hint = new Label(composite, 0);
        GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)hint);
        hint.setText(Messages.HINT_MORE_MESSAGES);
    }

    private void processNotificationData(Composite composite, Map<FeedDescriptor, PollingResult> sortedMap) {
        int feedCounter = 0;
        int messagesPerFeed = 6 < sortedMap.size() ? 1 : 6 / sortedMap.size();
        for (Map.Entry<FeedDescriptor, PollingResult> entry : sortedMap.entrySet()) {
            if (feedCounter >= 6) continue;
            Label feedTitle = new Label(composite, 0);
            GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)feedTitle);
            feedTitle.setFont(CommonFonts.BOLD);
            feedTitle.setText(entry.getKey().getName());
            feedCounter += this.processMessages(composite, entry.getValue().getMessages(), messagesPerFeed, entry.getKey());
        }
    }

    private int processMessages(Composite composite, List<IFeedMessage> messages, int calculatedMessagesPerFeed, final FeedDescriptor feed) {
        int messagesPerFeed = 0;
        for (final IFeedMessage message : messages) {
            if (messagesPerFeed >= calculatedMessagesPerFeed) continue;
            Link link = new Link(composite, 64);
            link.setText(MessageFormat.format("<a href=\"{1}\">{0}</a>", message.getTitle(), message.getUrl()));
            GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)link);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserUtils.openInDefaultBrowser(message.getUrl(), feed.getParameters());
                    NewsNotificationPopup.this.eventBus.post((Object)FeedEvents.createFeedMessageReadEvent(message.getId()));
                }
            });
            ++messagesPerFeed;
        }
        return messagesPerFeed;
    }

    @Override
    protected String getPopupShellTitle() {
        return Messages.NOTIFICATION_TITLE;
    }
}

