/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.models.rcp.DownloadModelArchiveJob;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ModelIndex;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.recommenders.utils.Zips;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EclipseModelIndex
extends AbstractIdleService
implements IModelIndex,
IRcpService {
    private static final Logger LOG = LoggerFactory.getLogger(EclipseModelIndex.class);
    private static final int CACHE_SIZE = 10;
    private final File basedir;
    private final ModelsRcpPreferences prefs;
    private final IModelRepository repository;
    private final EventBus bus;
    private volatile ImmutableMap<String, Pair<File, IModelIndex>> openDelegates;
    private final Cache<Pair<ProjectCoordinate, String>, Optional<ModelCoordinate>> cache = CacheBuilder.newBuilder().maximumSize(10L).concurrencyLevel(1).build();

    @Inject
    public EclipseModelIndex(@Named(value="INDEX_BASEDIR") File basedir, ModelsRcpPreferences prefs, IModelRepository repository, EventBus bus) {
        this.basedir = basedir;
        this.prefs = prefs;
        this.repository = repository;
        this.bus = bus;
    }

    @PreDestroy
    public void close() throws IOException {
        this.stopAsync();
        try {
            this.awaitTerminated(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CLOSING_MODEL_INDEX_SERVICE, (Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
        this.cache.invalidateAll();
        for (Pair delegate : this.openDelegates.values()) {
            this.removeDelegate((Pair<File, IModelIndex>)delegate);
            ((IModelIndex)delegate.getSecond()).close();
        }
    }

    @PostConstruct
    public void open() throws IOException {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        Checks.ensureNoDuplicates((String[])this.prefs.remotes);
        this.clearDelegates();
        this.basedir.mkdir();
        String[] stringArray = this.prefs.remotes;
        int n = this.prefs.remotes.length;
        int n2 = 0;
        while (n2 < n) {
            String remoteUrl = stringArray[n2];
            File file = this.createIndexLocation(remoteUrl);
            if (this.indexAlreadyDownloaded(file)) {
                this.openDelegate(remoteUrl, file);
            }
            this.triggerIndexDownload(remoteUrl);
            ++n2;
        }
    }

    @VisibleForTesting
    public void openForTesting() throws IOException {
        Checks.ensureNoDuplicates((String[])this.prefs.remotes);
        this.clearDelegates();
        String[] stringArray = this.prefs.remotes;
        int n = this.prefs.remotes.length;
        int n2 = 0;
        while (n2 < n) {
            String remoteUrl = stringArray[n2];
            File file = this.createIndexLocation(remoteUrl);
            this.openDelegate(remoteUrl, file);
            ++n2;
        }
    }

    private synchronized void storeDelegate(String remoteUrl, Pair<File, IModelIndex> pair) {
        this.openDelegates = new ImmutableMap.Builder().putAll(this.openDelegates).put((Object)remoteUrl, pair).build();
    }

    private synchronized void removeDelegate(Pair<File, IModelIndex> delegate) {
        HashMap delegates = Maps.newHashMap(this.openDelegates);
        delegates.values().remove(delegate);
        this.openDelegates = new ImmutableMap.Builder().putAll((Map)delegates).build();
    }

    private synchronized void clearDelegates() {
        this.openDelegates = ImmutableMap.of();
    }

    private void openDelegate(String remoteUrl, File indexLocation) throws IOException {
        IModelIndex modelIndex = this.createModelIndex(indexLocation);
        modelIndex.open();
        this.storeDelegate(remoteUrl, (Pair<File, IModelIndex>)Pair.newPair((Object)indexLocation, (Object)modelIndex));
        this.bus.post((Object)new ModelEvents.ModelIndexOpenedEvent());
    }

    private File createIndexLocation(String remoteUrl) {
        return new File(this.basedir, Urls.mangle((String)remoteUrl));
    }

    @VisibleForTesting
    protected IModelIndex createModelIndex(File indexLocation) {
        return new ModelIndex(indexLocation);
    }

    private void triggerIndexDownload(String remoteUrl) {
        ModelCoordinate mc = this.createIndexCoordinateWithRemoteUrlHint(remoteUrl);
        new DownloadModelArchiveJob(this.repository, mc, true, this.bus).schedule(300L);
    }

    private ModelCoordinate createIndexCoordinateWithRemoteUrlHint(String remoteUrl) {
        ModelCoordinate mc = new ModelCoordinate(INDEX.getGroupId(), INDEX.getArtifactId(), INDEX.getClassifier(), INDEX.getExtension(), INDEX.getVersion());
        return EclipseModelIndex.createCopyWithRepositoryUrlHint(mc, remoteUrl);
    }

    private boolean indexAlreadyDownloaded(File location) {
        if (!location.exists()) {
            return false;
        }
        File[] files = location.listFiles();
        if (files == null) {
            return false;
        }
        return files.length > 1;
    }

    public Optional<ModelCoordinate> suggest(final ProjectCoordinate pc, final String modelType) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return Optional.absent();
        }
        Pair key = Pair.newPair((Object)pc, (Object)modelType);
        try {
            return (Optional)this.cache.get((Object)key, (Callable)new Callable<Optional<ModelCoordinate>>(){

                @Override
                public Optional<ModelCoordinate> call() {
                    String[] stringArray = ((EclipseModelIndex)EclipseModelIndex.this).prefs.remotes;
                    int n = ((EclipseModelIndex)EclipseModelIndex.this).prefs.remotes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelIndex index;
                        Optional suggest;
                        String remote = stringArray[n2];
                        Pair pair = (Pair)EclipseModelIndex.this.openDelegates.get((Object)remote);
                        if (pair != null && (suggest = (index = (IModelIndex)pair.getSecond()).suggest(pc, modelType)).isPresent()) {
                            return Optional.of((Object)EclipseModelIndex.createCopyWithRepositoryUrlHint((ModelCoordinate)suggest.get(), remote));
                        }
                        ++n2;
                    }
                    return Optional.absent();
                }
            });
        }
        catch (ExecutionException e) {
            LOG.error("Exception occured while accessing model coordinates cache", (Throwable)e);
            return Optional.absent();
        }
    }

    public ImmutableSet<ModelCoordinate> suggestCandidates(ProjectCoordinate pc, String modelType) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return ImmutableSet.of();
        }
        HashSet candidates = Sets.newHashSet();
        for (Map.Entry entry : this.openDelegates.entrySet()) {
            IModelIndex index = (IModelIndex)((Pair)entry.getValue()).getSecond();
            candidates.addAll(EclipseModelIndex.addRepositoryUrlHint((Set<ModelCoordinate>)index.suggestCandidates(pc, modelType), (String)entry.getKey()));
        }
        return ImmutableSet.copyOf((Collection)candidates);
    }

    public ImmutableSet<ModelCoordinate> getKnownModels(String modelType) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return ImmutableSet.of();
        }
        HashSet models = Sets.newHashSet();
        for (Map.Entry entry : this.openDelegates.entrySet()) {
            IModelIndex index = (IModelIndex)((Pair)entry.getValue()).getSecond();
            models.addAll(EclipseModelIndex.addRepositoryUrlHint((Set<ModelCoordinate>)index.getKnownModels(modelType), (String)entry.getKey()));
        }
        return ImmutableSet.copyOf((Collection)models);
    }

    public Optional<ProjectCoordinate> suggestProjectCoordinateByArtifactId(String artifactId) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return Optional.absent();
        }
        for (Pair delegate : this.openDelegates.values()) {
            IModelIndex index = (IModelIndex)delegate.getSecond();
            Optional suggest = index.suggestProjectCoordinateByArtifactId(artifactId);
            if (!suggest.isPresent()) continue;
            return suggest;
        }
        return Optional.absent();
    }

    public Optional<ProjectCoordinate> suggestProjectCoordinateByFingerprint(String fingerprint) {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return Optional.absent();
        }
        for (Pair delegate : this.openDelegates.values()) {
            IModelIndex index = (IModelIndex)delegate.getSecond();
            Optional suggest = index.suggestProjectCoordinateByFingerprint(fingerprint);
            if (!suggest.isPresent()) continue;
            return suggest;
        }
        return Optional.absent();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryOpenedEvent e) throws Exception {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
        }
        this.startUp();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelIndexOpenedEvent e) {
        this.cache.invalidateAll();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryClosedEvent e) throws Exception {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
        }
        this.shutDown();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelArchiveDownloadedEvent e) throws IOException {
        if (!this.isRunning()) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_SERVICE_NOT_RUNNING);
            return;
        }
        if (this.isIndex(e.model)) {
            File location = (File)this.repository.getLocation(e.model, false).orNull();
            String remoteUrl = (String)e.model.getHint("repository.url").orNull();
            if (remoteUrl != null) {
                Pair pair = (Pair)this.openDelegates.get((Object)remoteUrl);
                if (pair == null) {
                    File folder = this.createIndexLocation(remoteUrl);
                    folder.mkdir();
                    Zips.unzip((File)location, (File)folder);
                    this.openDelegate(remoteUrl, folder);
                } else {
                    File folder = Files.createTempDir();
                    Zips.unzip((File)location, (File)folder);
                    IModelIndex modelIndex = (IModelIndex)pair.getSecond();
                    modelIndex.updateIndex(folder);
                    this.bus.post((Object)new ModelEvents.ModelIndexOpenedEvent());
                    FileUtils.deleteDirectory((File)folder);
                }
            }
        }
    }

    private boolean isIndex(ModelCoordinate model) {
        return model.getGroupId().equals(INDEX.getGroupId()) && model.getArtifactId().equals(INDEX.getArtifactId()) && model.getExtension().equals(INDEX.getExtension()) && model.getVersion().equals(INDEX.getVersion());
    }

    public void updateIndex(File index) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static Set<ModelCoordinate> addRepositoryUrlHint(Set<ModelCoordinate> modelCoordinates, String url) {
        HashSet modelCoordinatesWithUrlHint = Sets.newHashSet();
        for (ModelCoordinate modelCoordinate : modelCoordinates) {
            modelCoordinatesWithUrlHint.add(EclipseModelIndex.createCopyWithRepositoryUrlHint(modelCoordinate, url));
        }
        return modelCoordinatesWithUrlHint;
    }

    private static ModelCoordinate createCopyWithRepositoryUrlHint(ModelCoordinate mc, String url) {
        HashMap hints = Maps.newHashMap((Map)mc.getHints());
        hints.put("repository.url", url);
        ModelCoordinate copy = new ModelCoordinate(mc.getGroupId(), mc.getArtifactId(), mc.getClassifier(), mc.getExtension(), mc.getVersion(), (Map)hints);
        return copy;
    }
}

