/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedEvents;
import org.eclipse.recommenders.internal.news.rcp.MessageUtils;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpModule;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.internal.news.rcp.PollingResult;
import org.eclipse.recommenders.news.rcp.IFeedMessage;
import org.eclipse.recommenders.news.rcp.IJobFacade;
import org.eclipse.recommenders.news.rcp.INewsProperties;
import org.eclipse.recommenders.news.rcp.INewsService;
import org.eclipse.recommenders.news.rcp.INotificationFacade;
import org.eclipse.recommenders.news.rcp.IPollFeedJob;

@Creatable
@Singleton
public class NewsService
implements INewsService {
    private final NewsRcpPreferences preferences;
    private final INewsProperties newsFeedProperties;
    private final Set<String> readIds;
    private final IJobFacade jobFacade;
    private final EventBus bus;
    private final INotificationFacade notificationFacade;
    private final HashMap<FeedDescriptor, PollingResult> groupedMessages = Maps.newHashMap();

    @VisibleForTesting
    public NewsService(NewsRcpPreferences preferences, EventBus bus, INewsProperties newsFeedProperties, IJobFacade jobFacade, INotificationFacade notificationFacade) {
        this.preferences = preferences;
        bus.register((Object)this);
        this.bus = bus;
        this.readIds = newsFeedProperties.getReadIds();
        this.newsFeedProperties = newsFeedProperties;
        this.jobFacade = jobFacade;
        this.notificationFacade = notificationFacade;
    }

    @Inject
    public NewsService(NewsRcpPreferences preferences, INewsProperties newsProperties, IJobFacade jobFacade, INotificationFacade notificationFacade) {
        this(preferences, NewsRcpModule.EVENT_BUS, newsProperties, jobFacade, notificationFacade);
    }

    @Override
    public void start() {
        if (!NewsService.isRealEclipse()) {
            return;
        }
        this.doStart();
    }

    @VisibleForTesting
    protected void doStart() {
        if (!this.preferences.isEnabled()) {
            return;
        }
        this.jobFacade.schedulePollFeeds(this, this.getFeedsToPoll(true));
    }

    @Override
    public Map<FeedDescriptor, PollingResult> getMessages(final int countPerFeed) {
        Map transformedMap = Maps.transformValues(this.groupedMessages, (Function)new Function<PollingResult, PollingResult>(){

            public PollingResult apply(PollingResult input) {
                ImmutableList list = FluentIterable.from(input.getMessages()).limit(countPerFeed).toList();
                for (IFeedMessage message : list) {
                    if (!NewsService.this.readIds.contains(message.getId())) continue;
                    message.setRead(true);
                }
                return new PollingResult(input.getStatus(), (List<IFeedMessage>)list);
            }
        });
        return transformedMap;
    }

    @Override
    @Subscribe
    public void handleMessageRead(FeedEvents.FeedMessageReadEvent event) {
        if (event.getId() != null) {
            this.readIds.add(event.getId());
            this.newsFeedProperties.writeReadIds(this.readIds);
        }
    }

    @Override
    @Subscribe
    public void handleFeedRead(FeedEvents.FeedReadEvent event) {
        List<IFeedMessage> messages = this.groupedMessages.get(event.getFeed()).getMessages();
        for (IFeedMessage message : messages) {
            this.readIds.add(message.getId());
        }
        this.newsFeedProperties.writeReadIds(this.readIds);
    }

    @Override
    @Subscribe
    public void handleAllRead(FeedEvents.AllReadEvent event) {
        for (Map.Entry<FeedDescriptor, PollingResult> entry : this.groupedMessages.entrySet()) {
            for (IFeedMessage message : entry.getValue().getMessages()) {
                this.readIds.add(message.getId());
            }
        }
        this.newsFeedProperties.writeReadIds(this.readIds);
    }

    @Override
    public void jobDone(IPollFeedJob job) {
        boolean newMessage = false;
        Map<FeedDescriptor, PollingResult> messages = job.getMessages();
        for (Map.Entry<FeedDescriptor, PollingResult> entry : messages.entrySet()) {
            if (!this.groupedMessages.containsKey(entry.getKey())) {
                this.groupedMessages.put(entry.getKey(), entry.getValue());
                if (!entry.getValue().getMessages().isEmpty()) {
                    newMessage = true;
                }
            }
            List<IFeedMessage> feedMessages = this.groupedMessages.get(entry.getKey()).getMessages();
            for (IFeedMessage message : entry.getValue().getMessages()) {
                if (feedMessages.contains(message)) continue;
                feedMessages.add(message);
                newMessage = true;
            }
            this.groupedMessages.put(entry.getKey(), new PollingResult(entry.getValue().getStatus(), feedMessages));
        }
        if (!this.groupedMessages.isEmpty() && newMessage) {
            this.bus.post((Object)FeedEvents.createNewFeedItemsEvent());
            this.newsFeedProperties.writeDates(job.getPollDates(), "poll-dates.properties");
            this.updateReadIds();
        }
        if (!this.preferences.isEnabled()) {
            return;
        }
        this.jobFacade.scheduleNewsUpdate(this, TimeUnit.MINUTES.toMillis(this.preferences.getPollingInterval()));
        this.displayNotification();
    }

    @VisibleForTesting
    protected boolean shouldPoll(FeedDescriptor feed, boolean override) {
        if (!feed.isEnabled()) {
            return false;
        }
        if (override) {
            return true;
        }
        int pollingInterval = this.preferences.getPollingInterval().intValue();
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, pollingInterval);
        Date lhs = calendar.getTime();
        for (Map.Entry<String, Date> entry : this.newsFeedProperties.getDates("poll-dates.properties").entrySet()) {
            if (!entry.getKey().equals(feed.getId()) || !entry.getValue().after(lhs)) continue;
            return false;
        }
        return true;
    }

    private Set<FeedDescriptor> getFeedsToPoll(boolean override) {
        HashSet feeds = Sets.newHashSet();
        for (FeedDescriptor feed : this.preferences.getFeedDescriptors()) {
            if (!this.shouldPoll(feed, override)) continue;
            feeds.add(feed);
        }
        return feeds;
    }

    @Override
    public void removeFeed(FeedDescriptor feed) {
        if (this.groupedMessages.containsKey(feed)) {
            this.groupedMessages.remove(feed);
        }
    }

    @Override
    public void pollFeeds() {
        this.jobFacade.schedulePollFeeds(this, this.getFeedsToPoll(false));
    }

    @Override
    public void forceStop() {
        this.jobFacade.cancelPollFeeds();
    }

    @Override
    public void updateFeedDates(Map<FeedDescriptor, Date> map) {
        this.newsFeedProperties.writeDates(map, "feed-dates.properties");
    }

    private void updateReadIds() {
        HashSet result = Sets.newHashSet();
        HashSet allMessages = Sets.newHashSet();
        for (Map.Entry<FeedDescriptor, PollingResult> entry : this.groupedMessages.entrySet()) {
            for (IFeedMessage message : entry.getValue().getMessages()) {
                allMessages.add(message.getId());
            }
        }
        for (String s : this.readIds) {
            if (!allMessages.contains(s)) continue;
            result.add(s);
        }
        this.readIds.clear();
        this.readIds.addAll(result);
    }

    @Override
    public void displayNotification() {
        Map<FeedDescriptor, PollingResult> messages = MessageUtils.getLatestMessages(this.getMessages(20));
        if (!messages.isEmpty()) {
            this.notificationFacade.displayNotification(messages, this.bus);
            HashMap feedDates = Maps.newHashMap();
            for (Map.Entry<FeedDescriptor, PollingResult> entry : messages.entrySet()) {
                feedDates.put(entry.getKey(), Calendar.getInstance().getTime());
            }
            this.updateFeedDates(feedDates);
        }
    }

    public static boolean isRealEclipse() {
        return !Strings.isNullOrEmpty((String)System.getProperty("eclipse.buildId"));
    }
}

