/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.menus;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.recommenders.internal.news.rcp.BrowserUtils;
import org.eclipse.recommenders.internal.news.rcp.CommonImages;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedEvents;
import org.eclipse.recommenders.internal.news.rcp.MessageUtils;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.news.rcp.menus.MarkAsReadAction;
import org.eclipse.recommenders.internal.news.rcp.menus.PreferenceAction;
import org.eclipse.recommenders.news.rcp.IFeedMessage;
import org.eclipse.recommenders.news.rcp.INewsService;
import org.eclipse.recommenders.news.rcp.IPollingResult;

public class NewsMenuListener
implements IMenuListener {
    private final EventBus eventBus;
    private final INewsService service;
    private Map<FeedDescriptor, IPollingResult> messages;

    public NewsMenuListener(EventBus eventBus, INewsService service) {
        this.eventBus = eventBus;
        this.service = service;
    }

    public void setMessages(Map<FeedDescriptor, IPollingResult> messages) {
        this.messages = messages;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.messages = new TreeMap<FeedDescriptor, IPollingResult>(this.messages);
        for (Map.Entry<FeedDescriptor, IPollingResult> entry : this.messages.entrySet()) {
            String menuName = NewsMenuListener.getMenuEntryTitle(entry.getKey().getName(), entry.getValue().getMessages());
            MenuManager menu = new MenuManager(menuName, entry.getKey().getId());
            entry.getKey().getIcon();
            if (entry.getValue().getStatus().equals((Object)IPollingResult.Status.OK)) {
                this.groupEntries(menu, entry);
                this.addMarkAsReadAction(entry.getKey(), menu);
            } else {
                this.addStatusLabel(menu, entry.getValue().getStatus(), entry.getKey());
            }
            manager.add((IContributionItem)menu);
        }
        if (this.messages.isEmpty()) {
            manager.add((IAction)this.addAction(Messages.LABEL_ALL_FEEDS_DISABLED, false));
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)MarkAsReadAction.newMarkAllAsReadAction(this.eventBus));
        manager.add((IAction)this.newPollFeedsAction());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new PreferenceAction());
    }

    private void addMarkAsReadAction(FeedDescriptor feed, MenuManager menu) {
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)MarkAsReadAction.newMarkFeedAsReadAction(this.eventBus, feed));
    }

    private Action newPollFeedsAction() {
        return new Action(){

            public void run() {
                NewsMenuListener.this.service.start();
            }

            public ImageDescriptor getImageDescriptor() {
                return CommonImages.REFRESH;
            }

            public String getText() {
                return Messages.LABEL_POLL_FEEDS;
            }
        };
    }

    private void groupEntries(MenuManager menu, Map.Entry<FeedDescriptor, IPollingResult> entry) {
        List<List<IFeedMessage>> groupedMessages = MessageUtils.splitMessagesByAge(entry.getValue().getMessages());
        ImmutableList labels = ImmutableList.of((Object)Messages.LABEL_TODAY, (Object)Messages.LABEL_YESTERDAY, (Object)Messages.LABEL_THIS_WEEK, (Object)Messages.LABEL_LAST_WEEK, (Object)Messages.LABEL_THIS_MONTH, (Object)Messages.LABEL_LAST_MONTH, (Object)Messages.LABEL_THIS_YEAR, (Object)Messages.LABEL_OLDER_ENTRIES, (Object)Messages.LABEL_UNDETERMINED_ENTRIES);
        int i = 0;
        while (i < MessageUtils.MessageAge.values().length) {
            if (!groupedMessages.get(i).isEmpty()) {
                this.addLabel(menu, (String)labels.get(i));
                this.addMessages(menu, groupedMessages.get(i), entry.getKey());
            }
            ++i;
        }
    }

    private void addMessages(MenuManager menu, List<IFeedMessage> messages, final FeedDescriptor feed) {
        for (final IFeedMessage message : messages) {
            Action action = new Action(){

                public void run() {
                    BrowserUtils.openInDefaultBrowser(message.getUrl(), feed.getParameters());
                    NewsMenuListener.this.eventBus.post((Object)FeedEvents.createFeedMessageReadEvent(message.getId()));
                }
            };
            if (!message.isRead()) {
                action.setText(MessageFormat.format(Messages.UNREAD_MESSAGE, message.getTitle()));
            } else {
                action.setText(MessageFormat.format(Messages.READ_MESSAGE_OR_FEED, message.getTitle()));
            }
            menu.add((IAction)action);
        }
    }

    private void addLabel(MenuManager menu, String text) {
        Action action = new Action(){};
        action.setText(text);
        action.setEnabled(false);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)action);
    }

    private Action addAction(String text, boolean enabled) {
        Action action = new Action(){};
        action.setText(text);
        action.setEnabled(enabled);
        return action;
    }

    private void addStatusLabel(MenuManager menu, IPollingResult.Status status, FeedDescriptor feed) {
        Action action = new Action(){};
        if (status.equals((Object)IPollingResult.Status.FEEDS_NOT_POLLED_YET)) {
            action.setText(Messages.FEED_NOT_POLLED_YET);
        } else if (status.equals((Object)IPollingResult.Status.ERROR_CONNECTING_TO_FEED)) {
            action.setText(MessageFormat.format(Messages.LOG_WARNING_CONNECTING_URL, feed.getUrl()));
        } else if (status.equals((Object)IPollingResult.Status.FEED_NOT_FOUND_AT_URL)) {
            action.setText(MessageFormat.format(Messages.FEED_EMPTY, feed.getUrl()));
        }
        action.setEnabled(false);
        menu.add((IAction)action);
    }

    private static String getMenuEntryTitle(String feedName, List<IFeedMessage> messages) {
        int unreadMessages = MessageUtils.getUnreadMessagesNumber(messages);
        if (unreadMessages > 0) {
            return MessageFormat.format(Messages.UNREAD_FEED, feedName, unreadMessages);
        }
        return MessageFormat.format(Messages.READ_MESSAGE_OR_FEED, feedName);
    }
}

