/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.SearchContext;
import org.eclipse.recommenders.utils.Logs;

public class JavaEditorSearchContext
extends SearchContext {
    private final JavaContentAssistInvocationContext invocationContext;

    public JavaEditorSearchContext(String searchText, JavaContentAssistInvocationContext invocationContext, Set<ProjectCoordinate> projectCoordinates) {
        super(searchText, JavaEditorSearchContext.getLocation(invocationContext), projectCoordinates);
        this.invocationContext = invocationContext;
    }

    private static Location getLocation(JavaContentAssistInvocationContext context) {
        try {
            String partition = TextUtilities.getContentType((IDocument)context.getDocument(), (String)"___java_partitioning", (int)context.getInvocationOffset(), (boolean)true);
            return JavaEditorSearchContext.getLocation(context, partition);
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_COMPUTE_LOCATION, (Throwable)e);
            return Location.FILE;
        }
    }

    @VisibleForTesting
    static Location getLocation(JavaContentAssistInvocationContext context, String partition) {
        if (partition.equals("__java_javadoc")) {
            return Location.JAVADOC;
        }
        if (partition.equals("__java_singleline_comment") || partition.equals("__java_multiline_comment")) {
            return Location.FILE;
        }
        CompletionContext coreContext = context.getCoreContext();
        if (coreContext != null) {
            int tokenLocation = coreContext.getTokenLocation();
            if ((tokenLocation & 1) != 0) {
                return Location.JAVA_TYPE_MEMBERS;
            }
            if ((tokenLocation & 2) != 0) {
                return Location.JAVA_STATEMENTS;
            }
            return Location.UNKNOWN;
        }
        return Location.FILE;
    }

    public JavaContentAssistInvocationContext getInvocationContext() {
        return this.invocationContext;
    }
}

