/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;

public class BrowserUtils {
    private BrowserUtils() {
        throw new IllegalStateException("Not meant to be instantiated");
    }

    public static void openInDefaultBrowser(URL url, Map<String, String> parameters) {
        String stringUrl = null;
        try {
            stringUrl = parameters == null || parameters.isEmpty() ? url.toExternalForm() : BrowserUtils.encodeURI(url.toExternalForm(), parameters);
            IWebBrowser defaultBrowser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            defaultBrowser.openURL(new URL(stringUrl));
        }
        catch (Exception exception) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_URL_MALFORMED, stringUrl);
        }
    }

    @VisibleForTesting
    static String encodeURI(String url, Map<String, String> parameters) throws URISyntaxException {
        if (url == null) {
            return "";
        }
        if (parameters == null) {
            return url;
        }
        StringBuilder requestUrl = new StringBuilder(url);
        String query = URLEncodedUtils.format(BrowserUtils.toNameValuePairList(parameters), (String)"utf-8");
        if (!requestUrl.toString().contains("?")) {
            requestUrl.append("?");
            requestUrl.append(query);
        } else {
            requestUrl.append("&");
            requestUrl.append(query);
        }
        return URIUtil.fromString((String)requestUrl.toString()).toString();
    }

    private static List<NameValuePair> toNameValuePairList(Map<String, String> map) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        return result;
    }
}

