/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FeedDescriptor
implements Comparable<FeedDescriptor> {
    private final boolean defaultRepository;
    private final String id;
    private final URL url;
    private final String name;
    private final String pollingInterval;
    private final String description;
    private final String iconPath;
    private final Map<String, String> parameters;
    private boolean enabled;

    public FeedDescriptor(FeedDescriptor that) {
        this(that.getId(), that.getUrl().toString(), that.getName(), that.isEnabled(), that.isDefaultRepository(), that.getPollingInterval(), that.getDescription(), that.getIconPath(), that.getParameters());
    }

    public FeedDescriptor(IConfigurationElement config, boolean enabled) {
        this(config.getAttribute("id"), config.getAttribute("url"), config.getAttribute("name"), enabled, true, config.getAttribute("pollingInterval"), config.getAttribute("description"), config.getAttribute("icon"), FeedDescriptor.getParametersFromConfig(config));
    }

    public FeedDescriptor(String url, String name, String pollingInterval) {
        this(url, url, name, true, false, pollingInterval, null, null, null);
    }

    private FeedDescriptor(String id, String url, String name, boolean enabled, boolean defaultRepository, String pollingInterval, String description, String iconPath, Map<String, String> parameters) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkArgument((boolean)FeedDescriptor.isUrlValid(url), (Object)Messages.FEED_DESCRIPTOR_MALFORMED_URL);
        this.id = id;
        this.url = FeedDescriptor.stringToUrl(url);
        this.name = name;
        this.enabled = enabled;
        this.defaultRepository = defaultRepository;
        this.pollingInterval = pollingInterval;
        this.description = description;
        this.iconPath = iconPath;
        this.parameters = parameters;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isDefaultRepository() {
        return this.defaultRepository;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Image getIcon() {
        if (this.iconPath != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.news.rcp", (String)this.iconPath).createImage();
        }
        return null;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private String getIconPath() {
        return this.iconPath;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        FeedDescriptor that = (FeedDescriptor)other;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public static boolean isUrlValid(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
        return true;
    }

    private static URL stringToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FEED_MALFORMED_URL, url);
            return null;
        }
    }

    private static Map<String, String> getParametersFromConfig(IConfigurationElement config) {
        if (config == null) {
            return Collections.emptyMap();
        }
        IConfigurationElement[] urlParameters = config.getChildren("urlParameters");
        if (urlParameters == null || urlParameters.length < 1) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        IConfigurationElement[] parameters = urlParameters[0].getChildren("urlParameter");
        if (parameters.length < 1) {
            return Collections.emptyMap();
        }
        IConfigurationElement[] iConfigurationElementArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            result.put(element.getAttribute("key"), element.getAttribute("value"));
            ++n2;
        }
        return result;
    }

    @Override
    public int compareTo(FeedDescriptor that) {
        return this.getName().compareTo(that.getName());
    }
}

