/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;

public class FeedDescriptors {
    public static final char DISABLED_FLAG = '!';
    public static final char SEPARATOR = ';';
    private static final String EXT_ID_PROVIDER = "org.eclipse.recommenders.news.rcp.feed";

    public static List<FeedDescriptor> getRegisteredFeeds() {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_ID_PROVIDER);
        Arrays.sort(elements, new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement lhs, IConfigurationElement rhs) {
                return lhs.getAttribute("name").compareTo(rhs.getAttribute("name"));
            }
        });
        LinkedList feeds = Lists.newLinkedList();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            boolean enabled = true;
            FeedDescriptor feed = new FeedDescriptor(element, enabled);
            if (!feeds.contains(feed)) {
                feeds.add(feed);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.WARNING_DUPLICATE_FEED, feed.getId(), feed.getName());
            }
            ++n2;
        }
        return feeds;
    }

    public static List<FeedDescriptor> getFeeds(String json) {
        if (json == null || json.isEmpty()) {
            return Collections.emptyList();
        }
        Gson gson = new GsonBuilder().create();
        Type collectionType = new TypeToken<List<FeedDescriptor>>(){}.getType();
        List list = (List)gson.fromJson(json, collectionType);
        Collections.sort(list, new Comparator<FeedDescriptor>(){

            @Override
            public int compare(FeedDescriptor lhs, FeedDescriptor rhs) {
                return lhs.getName().compareTo(rhs.getName());
            }
        });
        return list;
    }

    public static List<FeedDescriptor> load(String preferenceString, List<FeedDescriptor> available) {
        ArrayList result = Lists.newArrayList();
        String[] stringArray = StringUtils.split((String)Strings.nullToEmpty((String)preferenceString), (char)';');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean enabled;
            String id = stringArray[n2];
            if (id.charAt(0) == '!') {
                enabled = false;
                id = id.substring(1);
            } else {
                enabled = true;
            }
            FeedDescriptor found = FeedDescriptors.find(available, id);
            if (found != null) {
                FeedDescriptor feed = new FeedDescriptor(found);
                feed.setEnabled(enabled);
                result.add(feed);
            }
            ++n2;
        }
        for (FeedDescriptor feed : available) {
            if (FeedDescriptors.find(result, feed.getId()) != null) continue;
            result.add(feed);
        }
        return result;
    }

    public static String feedsToString(List<FeedDescriptor> descriptors) {
        StringBuilder sb = new StringBuilder();
        Iterator<FeedDescriptor> it = descriptors.iterator();
        while (it.hasNext()) {
            FeedDescriptor feed = it.next();
            if (sb.toString().contains(feed.getId())) continue;
            if (!feed.isEnabled()) {
                sb.append('!');
            }
            sb.append(feed.getId());
            if (!it.hasNext()) continue;
            sb.append(';');
        }
        String result = sb.toString();
        if (result.length() > 1 && result.lastIndexOf(59) == result.length() - 1) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public static String customFeedsToString(List<FeedDescriptor> feeds) {
        Gson gson = new GsonBuilder().create();
        return gson.toJson(feeds);
    }

    private static FeedDescriptor find(List<FeedDescriptor> feeds, String id) {
        for (FeedDescriptor feed : feeds) {
            if (!feed.getId().equals(id)) continue;
            return feed;
        }
        return null;
    }
}

