/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.inject.Singleton;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.PollFeedJob;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.news.rcp.IJobFacade;
import org.eclipse.recommenders.news.rcp.INewsService;
import org.osgi.framework.FrameworkUtil;

@Creatable
@Singleton
public class JobFacade
implements IJobFacade {
    @Override
    public void scheduleNewsUpdate(final INewsService service, long delay) {
        this.cancelPollFeeds();
        Job job = new Job(Messages.POLL_FEED_JOB_SCHEDULER_NAME){

            protected IStatus run(IProgressMonitor monitor) {
                service.pollFeeds();
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.setPriority(50);
        if (FrameworkUtil.getBundle(this.getClass()).getState() == 32) {
            job.schedule(delay);
        }
    }

    @Override
    public void schedulePollFeeds(final INewsService service, Set<FeedDescriptor> feeds) {
        final PollFeedJob job = new PollFeedJob(feeds);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                service.jobDone(job);
            }
        });
        job.schedule();
    }

    @Override
    public void cancelPollFeeds() {
        Job.getJobManager().cancel((Object)"newsFeedJob");
    }
}

