/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.NewsProperties;
import org.eclipse.recommenders.internal.news.rcp.PollingResult;
import org.eclipse.recommenders.news.rcp.IFeedMessage;
import org.eclipse.recommenders.news.rcp.IPollingResult;

public class MessageUtils {
    public static boolean containsUnreadMessages(Map<FeedDescriptor, IPollingResult> map) {
        if (map == null) {
            return false;
        }
        for (Map.Entry<FeedDescriptor, IPollingResult> entry : map.entrySet()) {
            for (IFeedMessage message : entry.getValue().getMessages()) {
                if (message.isRead()) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<FeedDescriptor, IPollingResult> getLatestMessages(Map<FeedDescriptor, IPollingResult> messages) {
        Preconditions.checkNotNull(messages);
        HashMap result = Maps.newHashMap();
        for (Map.Entry<FeedDescriptor, IPollingResult> entry : messages.entrySet()) {
            List<IFeedMessage> list = MessageUtils.updateMessages(entry);
            if (list.isEmpty()) continue;
            result.put(entry.getKey(), new PollingResult(entry.getValue().getStatus(), list));
        }
        return MessageUtils.sortByDate(result);
    }

    public static List<IFeedMessage> updateMessages(Map.Entry<FeedDescriptor, IPollingResult> entry) {
        NewsProperties properties = new NewsProperties();
        ArrayList feedMessages = Lists.newArrayList();
        for (IFeedMessage message : entry.getValue().getMessages()) {
            if (properties.getDates("feed-dates.properties").get(entry.getKey().getId()) == null) {
                feedMessages.add(message);
                continue;
            }
            if (message.getDate() == null || !message.getDate().after(properties.getDates("feed-dates.properties").get(entry.getKey().getId()))) continue;
            feedMessages.add(message);
        }
        return feedMessages;
    }

    public static int getUnreadMessagesNumber(List<IFeedMessage> messages) {
        if (messages == null) {
            return 0;
        }
        int counter = 0;
        for (IFeedMessage message : messages) {
            if (message.isRead()) continue;
            ++counter;
        }
        return counter;
    }

    public static List<IFeedMessage> mergeMessages(Map<FeedDescriptor, IPollingResult> messages) {
        if (messages == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (Map.Entry<FeedDescriptor, IPollingResult> entry : messages.entrySet()) {
            result.addAll(entry.getValue().getMessages());
        }
        return result;
    }

    public static Map<FeedDescriptor, IPollingResult> sortByDate(Map<FeedDescriptor, IPollingResult> map) {
        if (map == null) {
            return Maps.newHashMap();
        }
        for (Map.Entry<FeedDescriptor, IPollingResult> entry : map.entrySet()) {
            List<IFeedMessage> list = entry.getValue().getMessages();
            Collections.sort(list, new Comparator<IFeedMessage>(){

                @Override
                public int compare(IFeedMessage lhs, IFeedMessage rhs) {
                    if (rhs.getDate() == null || lhs.getDate() == null) {
                        return 0;
                    }
                    return rhs.getDate().compareTo(lhs.getDate());
                }
            });
            entry.setValue(new PollingResult(entry.getValue().getStatus(), list));
        }
        return map;
    }

    public static List<List<IFeedMessage>> splitMessagesByAge(List<IFeedMessage> messages) {
        Locale locale = Locale.getDefault();
        Calendar calendar = Calendar.getInstance(locale);
        return MessageUtils.splitMessagesByAge(messages, calendar.getTime(), locale);
    }

    @VisibleForTesting
    public static List<List<IFeedMessage>> splitMessagesByAge(List<IFeedMessage> messages, Date now, Locale locale) {
        ArrayList result = Lists.newArrayList();
        int i = 0;
        while (i < MessageAge.values().length) {
            ArrayList list = Lists.newArrayList();
            result.add(list);
            ++i;
        }
        if (messages == null) {
            return result;
        }
        Date today = DateUtils.truncate((Date)now, (int)5);
        for (IFeedMessage message : messages) {
            MessageAge[] messageAgeArray = MessageAge.values();
            int n = messageAgeArray.length;
            int n2 = 0;
            while (n2 < n) {
                MessageAge messageAge = messageAgeArray[n2];
                if (message.getDate() == null) {
                    ((List)result.get(MessageAge.UNDETERMINED.getIndex())).add(message);
                    break;
                }
                if (message.getDate().after(MessageUtils.getPeriodStartDate(messageAge, today, locale)) || message.getDate().equals(MessageUtils.getPeriodStartDate(messageAge, today, locale))) {
                    ((List)result.get(messageAge.getIndex())).add(message);
                    break;
                }
                ++n2;
            }
            if (message.getDate() == null || !message.getDate().before(MessageUtils.getPeriodStartDate(MessageAge.OLDER, today, locale)) && !message.getDate().equals(MessageUtils.getPeriodStartDate(MessageAge.OLDER, today, locale))) continue;
            ((List)result.get(MessageAge.OLDER.getIndex())).add(message);
        }
        return result;
    }

    public static Date getPeriodStartDate(MessageAge messageAge, Date today, Locale locale) {
        Calendar calendar = GregorianCalendar.getInstance(locale);
        calendar.setTime(today);
        if (messageAge == MessageAge.TODAY) {
            return calendar.getTime();
        }
        if (messageAge == MessageAge.YESTERDAY) {
            calendar.add(5, -1);
        } else if (messageAge == MessageAge.THIS_WEEK) {
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            calendar.set(7, firstDayOfWeek);
        } else if (messageAge == MessageAge.LAST_WEEK) {
            int firstDayOfWeek = calendar.getFirstDayOfWeek();
            calendar.set(7, firstDayOfWeek);
            calendar.add(5, -1);
            calendar.set(7, firstDayOfWeek);
        } else if (messageAge == MessageAge.THIS_MONTH) {
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.LAST_MONTH) {
            calendar.set(5, 1);
            calendar.add(5, -1);
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.THIS_YEAR) {
            calendar.set(2, 0);
            calendar.set(5, 1);
        } else if (messageAge == MessageAge.OLDER) {
            calendar.set(1, calendar.get(1) - 1);
            calendar.set(2, 11);
            calendar.set(5, 31);
        }
        return calendar.getTime();
    }

    public static enum MessageAge {
        TODAY(0),
        YESTERDAY(1),
        THIS_WEEK(2),
        LAST_WEEK(3),
        THIS_MONTH(4),
        LAST_MONTH(5),
        THIS_YEAR(6),
        OLDER(7),
        UNDETERMINED(8);

        private final int index;

        private MessageAge(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

