/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedReader;
import org.eclipse.recommenders.internal.news.rcp.Constants;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedMessage;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.PollingResult;
import org.eclipse.recommenders.internal.news.rcp.Proxies;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.news.rcp.IFeedMessage;
import org.eclipse.recommenders.news.rcp.IPollFeedJob;
import org.eclipse.recommenders.news.rcp.IPollingResult;
import org.osgi.framework.FrameworkUtil;

public class PollFeedJob
extends Job
implements IPollFeedJob {
    private final NotificationEnvironment environment;
    private final Map<FeedDescriptor, IPollingResult> groupedMessages = Maps.newHashMap();
    private final Set<FeedDescriptor> feeds = Sets.newHashSet();
    private final Map<FeedDescriptor, Date> pollDates = Maps.newHashMap();

    public PollFeedJob(Collection<FeedDescriptor> feeds) {
        super(Messages.POLL_FEED_JOB_NAME);
        Preconditions.checkNotNull(feeds);
        this.environment = new NotificationEnvironment();
        this.feeds.addAll(feeds);
        this.setPriority(50);
        this.setRule(new MutexRule());
    }

    protected IStatus run(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.feeds.size() * 100));
        try {
            Executor executor = Executor.newInstance();
            for (FeedDescriptor feed : this.feeds) {
                if (monitor.isCanceled() || FrameworkUtil.getBundle(this.getClass()).getState() != 32) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.pollFeed(monitor, sub, executor, feed);
            }
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    private void pollFeed(IProgressMonitor monitor, SubMonitor sub, Executor executor, FeedDescriptor feed) {
        try {
            URI feedUri = (URI)PollFeedJob.urlToUri(feed.getUrl()).orNull();
            if (feedUri != null) {
                Response response = this.connectToUrl(feed, executor, feedUri);
                sub.worked(10);
                this.updateGroupedMessages(response.returnResponse(), feed, (IProgressMonitor)sub.newChild(80));
                this.pollDates.put(feed, new Date());
                sub.worked(10);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.WARNING_CONNECTING_URL, feed.getUrl());
                this.groupedMessages.put(feed, PollingResult.newConnectionErrorResult());
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.groupedMessages.put(feed, PollingResult.newConnectionErrorResult());
        }
        catch (IOException iOException) {
            Logs.log((Logs.ILogMessage)LogMessages.WARNING_CONNECTING_URL, feed.getUrl());
            this.groupedMessages.put(feed, PollingResult.newConnectionErrorResult());
        }
    }

    private Response connectToUrl(FeedDescriptor feed, Executor executor, URI feedUri) throws ClientProtocolException, IOException {
        Request request = Request.Get((URI)feedUri).viaProxy((HttpHost)Proxies.getProxyHost(feedUri).orNull()).connectTimeout((int)Constants.CONNECTION_TIMEOUT).staleConnectionCheck(true).socketTimeout((int)Constants.SOCKET_TIMEOUT);
        Response response = Proxies.proxyAuthentication(executor, feedUri).execute(request);
        return response;
    }

    public boolean belongsTo(Object job) {
        return Objects.equals("newsFeedJob", job);
    }

    private void updateGroupedMessages(HttpResponse httpResponse, FeedDescriptor feed, IProgressMonitor monitor) {
        monitor.subTask(MessageFormat.format(Messages.POLL_FEED_JOB_SUBTASK_POLLING_FEED, feed.getName()));
        try {
            if (monitor.isCanceled() || FrameworkUtil.getBundle(this.getClass()).getState() != 32) {
                return;
            }
            if (httpResponse.getStatusLine().getStatusCode() >= 400) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_CONNECTING_URL_WITH_STATUS_CODE, feed.getUrl(), httpResponse.getStatusLine().getStatusCode());
                return;
            }
            try {
                IPollingResult.Status status = IPollingResult.Status.OK;
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedInputStream in = new BufferedInputStream(httpResponse.getEntity().getContent());){
                    ArrayList messages = Lists.newArrayList(this.readMessages(in, monitor, feed.getId()));
                    if (messages.isEmpty()) {
                        status = IPollingResult.Status.FEED_NOT_FOUND_AT_URL;
                    }
                    this.groupedMessages.put(feed, new PollingResult(status, messages));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FETCHING_MESSAGES, e, feed.getUrl());
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<? extends IFeedMessage> readMessages(InputStream in, IProgressMonitor monitor, String eventId) throws IOException {
        FeedReader reader = new FeedReader(eventId, this.environment);
        reader.parse(in, monitor);
        return FluentIterable.from((Iterable)reader.getEntries()).transform((Function)new Function<FeedEntry, IFeedMessage>(){

            public IFeedMessage apply(FeedEntry entry) {
                return new FeedMessage(entry.getId(), entry.getDate(), entry.getDescription(), entry.getTitle(), PollFeedJob.toUrl(entry.getUrl()));
            }
        }).toList();
    }

    @Override
    public Map<FeedDescriptor, IPollingResult> getMessages() {
        return this.groupedMessages;
    }

    @Override
    public Map<FeedDescriptor, Date> getPollDates() {
        return this.pollDates;
    }

    private static Optional<URI> urlToUri(URL url) {
        try {
            return Optional.of((Object)url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
    }

    @VisibleForTesting
    static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    class MutexRule
    implements ISchedulingRule {
        MutexRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

