/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.menus;

import com.google.common.eventbus.EventBus;
import org.eclipse.jface.action.Action;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedEvents;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;

public class MarkAsReadAction
extends Action {
    private final EventBus eventBus;
    private final Boolean allFeeds;
    private final FeedDescriptor feed;

    private MarkAsReadAction(EventBus eventBus, FeedDescriptor feed, boolean allFeeds) {
        this.eventBus = eventBus;
        this.allFeeds = allFeeds;
        this.feed = feed;
    }

    public static MarkAsReadAction newMarkFeedAsReadAction(EventBus eventBus, FeedDescriptor feed) {
        return new MarkAsReadAction(eventBus, feed, false);
    }

    public static MarkAsReadAction newMarkAllAsReadAction(EventBus eventBus) {
        return new MarkAsReadAction(eventBus, null, true);
    }

    public void run() {
        if (this.allFeeds.booleanValue()) {
            this.eventBus.post((Object)FeedEvents.createAllReadEvent());
            return;
        }
        this.eventBus.post((Object)FeedEvents.createFeedReadEvent(this.feed));
    }

    public String getText() {
        return Messages.LABEL_MARK_AS_READ;
    }
}

