/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.recommenders.internal.types.rcp.IProjectTypesIndex;
import org.eclipse.recommenders.internal.types.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.types.rcp.l10n.Messages;
import org.eclipse.recommenders.jdt.JavaElementsFinder;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;

public class ProjectTypesIndex
extends AbstractIdleService
implements IProjectTypesIndex {
    private static final String F_PACAKGE_FRAGEMENT_ROOT_TYPE = "pfrType";
    private static final String F_NAME = "name";
    private static final String F_LAST_MODIFIED = "lastModified";
    private static final String F_LOCATION = "location";
    private static final String F_INSTANCEOF = "instanceof";
    private static final String V_JAVA_LANG_OBJECT = "java.lang.Object";
    private static final String V_ARCHIVE = "archive";
    private static final TermQuery TERM_QUERY_PACKAGE_FRAGMENT_ROOT_TYPE = new TermQuery(new Term("pfrType", "archive"));
    private final IJavaProject project;
    private final File indexDir;
    private Directory directory;
    private IndexWriter writer;
    private JobFuture activeRebuild = null;
    private boolean rebuildAfterNextAccess;
    private final File onlyIndexedJar;
    private SearcherManager searchManager;

    public ProjectTypesIndex(IJavaProject project, File indexDir) {
        this(project, indexDir, null);
    }

    @VisibleForTesting
    ProjectTypesIndex(IJavaProject project, File indexDir, File onlyIndexedJar) {
        this.project = project;
        this.indexDir = indexDir;
        this.onlyIndexedJar = onlyIndexedJar;
        if (onlyIndexedJar == null) {
            this.startAsync();
        }
    }

    protected void startUp() throws Exception {
        this.initialize();
        if (this.needsRebuild()) {
            this.rebuild();
        }
    }

    @VisibleForTesting
    void initialize() throws IOException {
        this.directory = FSDirectory.open((File)this.indexDir);
        if (IndexWriter.isLocked((Directory)this.directory)) {
            IndexWriter.unlock((Directory)this.directory);
        }
        IndexWriterConfig conf = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        this.writer = new IndexWriter(this.directory, conf);
        this.writer.commit();
        this.searchManager = new SearcherManager(this.directory, null, null);
    }

    @VisibleForTesting
    boolean needsRebuild() {
        List<IPackageFragmentRoot> roots = this.findArchivePackageFragmentRoots();
        StringBuilder sb = new StringBuilder();
        try {
            Set<File> indexedRoots = this.getIndexedRoots();
            for (IPackageFragmentRoot root : roots) {
                File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
                if (!indexedRoots.remove(location)) {
                    sb.append("  [+] ").append(location).append('\n');
                    continue;
                }
                if (this.isCurrent(root)) continue;
                sb.append("  [*] ").append(location).append('\n');
            }
            if (!indexedRoots.isEmpty()) {
                for (File file : indexedRoots) {
                    sb.append("  [-] ").append(file.getAbsolutePath()).append('\n');
                }
            }
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
        if (sb.length() > 0) {
            Logs.log((Logs.ILogMessage)LogMessages.INFO_REINDEXING_REQUIRED, (Object[])new Object[]{sb.toString()});
            return true;
        }
        return false;
    }

    private List<IPackageFragmentRoot> findArchivePackageFragmentRoots() {
        Iterable filtered = Iterables.filter((Iterable)JavaElementsFinder.findPackageFragmentRoots((IJavaProject)this.project), (Predicate)new ArchiveFragmentRootsOnlyPredicate());
        Iterable result = Iterables.filter((Iterable)filtered, (Predicate)new Predicate<IPackageFragmentRoot>(){

            public boolean apply(IPackageFragmentRoot input) {
                return ProjectTypesIndex.this.onlyIndexedJar == null || input.getPath().toFile().equals(ProjectTypesIndex.this.onlyIndexedJar);
            }
        });
        return Ordering.usingToString().sortedCopy(result);
    }

    private Set<File> getIndexedRoots() throws IOException {
        HashSet res = Sets.newHashSet();
        IndexSearcher searcher = this.searchManager.acquire();
        try {
            TopDocs topDocs = searcher.search((Query)TERM_QUERY_PACKAGE_FRAGMENT_ROOT_TYPE, Integer.MAX_VALUE);
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            int n = topDocs.scoreDocs.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreDoc scoreDoc = scoreDocArray[n2];
                Document doc = searcher.doc(scoreDoc.doc);
                File location = new File(doc.get(F_LOCATION));
                res.add(location);
                ++n2;
            }
        }
        finally {
            this.releaseQuietly(searcher);
        }
        return res;
    }

    private boolean isCurrent(IPackageFragmentRoot root) throws IOException {
        File rootLocation = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
        BooleanQuery query = new BooleanQuery();
        query.add((Query)new TermQuery(this.termLocation(rootLocation)), BooleanClause.Occur.MUST);
        query.add((Query)NumericRangeQuery.newLongRange((String)F_LAST_MODIFIED, (Long)rootLocation.lastModified(), (Long)rootLocation.lastModified(), (boolean)true, (boolean)true), BooleanClause.Occur.MUST);
        IndexSearcher searcher = this.searchManager.acquire();
        try {
            boolean bl = searcher.search((Query)query, (int)1).totalHits > 0;
            return bl;
        }
        finally {
            this.releaseQuietly(searcher);
        }
    }

    private Term termLocation(File rootLocation) {
        return new Term(F_LOCATION, rootLocation.getAbsolutePath());
    }

    @Override
    public void close() throws IOException {
        this.stopAsync();
        this.awaitTerminated();
    }

    protected void shutDown() throws Exception {
        this.cancelRebuild();
        IOUtils.close((Closeable[])new Closeable[]{this.writer, this.directory});
        this.searchManager.close();
    }

    @Override
    public ImmutableSet<String> subtypes(ITypeName expected) {
        if (!this.isRunning()) {
            return ImmutableSet.of();
        }
        try {
            return this.doSubtypes(expected);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
            return ImmutableSet.of();
        }
    }

    @VisibleForTesting
    protected ImmutableSet<String> doSubtypes(ITypeName expected) {
        ImmutableSet.Builder b;
        block8: {
            if (expected == null) {
                return ImmutableSet.of();
            }
            String type = Names.vm2srcQualifiedType((ITypeName)expected);
            b = ImmutableSet.builder();
            IndexSearcher searcher = this.searchManager.acquire();
            try {
                try {
                    TermQuery query = new TermQuery(new Term(F_INSTANCEOF, type));
                    TopDocs search = searcher.search((Query)query, Integer.MAX_VALUE);
                    ScoreDoc[] scoreDocArray = search.scoreDocs;
                    int n = search.scoreDocs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScoreDoc sdoc = scoreDocArray[n2];
                        Document doc = searcher.doc(sdoc.doc);
                        String name = doc.get(F_NAME);
                        b.add((Object)name);
                        ++n2;
                    }
                }
                catch (Exception e) {
                    Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
                    this.releaseQuietly(searcher);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.releaseQuietly(searcher);
                throw throwable;
            }
            this.releaseQuietly(searcher);
        }
        if (this.isRebuildAfterNextAccess()) {
            this.setRebuildAfterNextAccess(false);
            this.rebuild();
        }
        return b.build();
    }

    private void releaseQuietly(IndexSearcher searcher) {
        try {
            this.searchManager.release(searcher);
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    private void clear() {
        try {
            this.writer.deleteAll();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    private void rebuild() {
        JobFuture res;
        this.cancelRebuild();
        this.activeRebuild = res = new JobFuture();
        Job job = new Job(MessageFormat.format(Messages.JOB_NAME_INDEXING, this.project.getElementName())){

            protected IStatus run(IProgressMonitor monitor) {
                Thread thread = Thread.currentThread();
                int priority = thread.getPriority();
                try {
                    thread.setPriority(1);
                    IStatus iStatus = this.doRun(monitor);
                    return iStatus;
                }
                finally {
                    thread.setPriority(priority);
                }
            }

            private IStatus doRun(IProgressMonitor monitor) {
                block7: {
                    try {
                        ProjectTypesIndex.this.clear();
                        ProjectTypesIndex.this.rebuild(monitor);
                        ProjectTypesIndex.this.commit();
                    }
                    catch (OperationCanceledException e) {
                        res.setException(e);
                        res.setResult(Status.CANCEL_STATUS);
                        monitor.done();
                        break block7;
                    }
                    catch (Exception e) {
                        try {
                            res.setException(e);
                            res.setResult((IStatus)new Status(4, "org.eclipse.recommenders.types.rcp", e.getMessage(), (Throwable)e));
                            break block7;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            monitor.done();
                        }
                    }
                    monitor.done();
                }
                res.setResult(Status.OK_STATUS);
                return Status.OK_STATUS;
            }
        };
        res.setJob(job);
        job.schedule(2000L);
    }

    @VisibleForTesting
    synchronized void rebuild(IProgressMonitor monitor) {
        List<IPackageFragmentRoot> roots = this.findArchivePackageFragmentRoots();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MONITOR_NAME_INDEXING, (int)roots.size());
        for (IPackageFragmentRoot root : roots) {
            this.rebuildRoot(root, progress.newChild(1));
        }
    }

    private void rebuildRoot(IPackageFragmentRoot root, SubMonitor monitor) {
        ImmutableList types = JavaElementsFinder.findTypes((IPackageFragmentRoot)root);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)types.size());
        progress.subTask(root.getElementName());
        for (IType type : types) {
            if (progress.isCanceled()) {
                this.setRebuildAfterNextAccess(true);
                throw new OperationCanceledException();
            }
            this.indexType(type, progress.newChild(1));
        }
        File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)root).orNull();
        if (location != null) {
            this.registerArchivePackageFragmentRoot(location);
        }
        this.commit();
    }

    private void cancelRebuild() {
        if (this.activeRebuild != null && !this.activeRebuild.isDone() && !this.activeRebuild.isCancelled()) {
            this.activeRebuild.cancel(true);
        }
    }

    private void registerArchivePackageFragmentRoot(File location) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_PACAKGE_FRAGEMENT_ROOT_TYPE, V_ARCHIVE, Field.Store.NO, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(F_LOCATION, location.getAbsolutePath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new NumericField(F_LAST_MODIFIED, Field.Store.YES, true).setLongValue(location.lastModified()));
        try {
            this.writer.addDocument(doc);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    private void commit() {
        try {
            this.writer.commit();
            this.searchManager.maybeReopen();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
        }
    }

    private void indexType(IType type, SubMonitor monitor) {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_NAME, type.getFullyQualifiedName(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        File location = (File)this.findPackageFragmentRoot(type).orNull();
        if (location != null) {
            doc.add((Fieldable)new Field(F_LOCATION, location.getAbsolutePath(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        doc.add((Fieldable)new Field(F_INSTANCEOF, type.getFullyQualifiedName(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        try {
            ITypeHierarchy h = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = h.getAllSupertypes(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IType supertypes = iTypeArray[n2];
                String fullyQualifiedName = supertypes.getFullyQualifiedName();
                if (!Objects.equal((Object)V_JAVA_LANG_OBJECT, (Object)fullyQualifiedName)) {
                    doc.add((Fieldable)new Field(F_INSTANCEOF, fullyQualifiedName, Field.Store.NO, Field.Index.NOT_ANALYZED));
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_TYPE_HIERARCHY, (Throwable)e, (Object[])new Object[]{type});
        }
        this.addDocument(doc, (IProgressMonitor)monitor);
    }

    private void addDocument(Document doc, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            try {
                if (!monitor.isCanceled()) {
                    this.writer.addDocument(doc);
                }
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_ACCESSING_SEARCHINDEX_FAILED, (Throwable)e);
                progress.worked(1);
            }
        }
        finally {
            progress.worked(1);
        }
    }

    private Optional<File> findPackageFragmentRoot(IType type) {
        IPackageFragmentRoot ancestor = (IPackageFragmentRoot)type.getAncestor(3);
        return JavaElementsFinder.findLocation((IPackageFragmentRoot)ancestor);
    }

    @Override
    public void suggestRebuild() {
        this.setRebuildAfterNextAccess(this.needsRebuild());
    }

    private void setRebuildAfterNextAccess(boolean value) {
        this.rebuildAfterNextAccess = value;
    }

    private boolean isRebuildAfterNextAccess() {
        return this.rebuildAfterNextAccess;
    }

    @Override
    public void delete() {
        this.stopAsync();
        this.awaitTerminated();
        FileUtils.deleteQuietly((File)this.indexDir);
    }

    private static final class ArchiveFragmentRootsOnlyPredicate
    implements Predicate<IPackageFragmentRoot> {
        private ArchiveFragmentRootsOnlyPredicate() {
        }

        public boolean apply(IPackageFragmentRoot input) {
            if (input == null) {
                return false;
            }
            if (!input.isArchive()) {
                return false;
            }
            File location = (File)JavaElementsFinder.findLocation((IPackageFragmentRoot)input).orNull();
            return location != null;
        }
    }

    private static final class JobFuture
    extends AbstractFuture<IStatus> {
        private Job job;

        private JobFuture() {
        }

        public void setJob(Job job) {
            this.job = job;
        }

        public boolean setResult(IStatus value) {
            return super.set((Object)value);
        }

        public boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.job != null) {
                return this.job.cancel();
            }
            return false;
        }
    }
}

