/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.eventbus.EventBus;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.models.rcp.MultipleDownloadCallback;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.rcp.Browsers;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;

public class DownloadModelArchiveJob
extends Job {
    private static final int MAXIMUM_NUMBER_OF_DOWNLOADS_PER_JOB = 2;
    private static final int TOTAL_WORK_UNITS = 100000;
    private final IModelRepository repository;
    private final ModelCoordinate mc;
    private final boolean forceDownload;
    private final EventBus bus;

    public DownloadModelArchiveJob(IModelRepository repository, ModelCoordinate mc, boolean forceDownload, EventBus bus) {
        super(MessageFormat.format(Messages.JOB_NAME_RESOLVING_MODEL, mc));
        this.repository = repository;
        this.mc = mc;
        this.forceDownload = forceDownload;
        this.bus = bus;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String message = MessageFormat.format(Messages.MONITOR_NAME_RESOLVING_MODEL, this.mc);
            MultipleDownloadCallback downloadCallback = new MultipleDownloadCallback(monitor, message, 100000, 2);
            File result = (File)this.repository.resolve(this.mc, this.forceDownload, (DownloadCallback)downloadCallback).orNull();
            boolean isDownloadSuccessful = downloadCallback.isDownloadSucceeded();
            if (isDownloadSuccessful) {
                this.bus.post((Object)new ModelEvents.ModelArchiveDownloadedEvent(this.mc));
            }
            downloadCallback.finish();
            if (result == null) {
                if (this.isIndex(this.mc)) {
                    final Display display = PlatformUI.getWorkbench().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IndexDownloadFailureDialog dialog = new IndexDownloadFailureDialog(display.getActiveShell());
                            if (!dialog.isIgnored()) {
                                dialog.open();
                            }
                        }
                    });
                }
                Status err = new Status(1, "org.eclipse.recommenders.models.rcp", MessageFormat.format(Messages.LOG_INFO_NO_MODEL_RESOLVED, this.mc));
                StatusManager.getManager().handle((IStatus)err, 1);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.recommenders.models.rcp", MessageFormat.format(Messages.LOG_ERROR_MODEL_RESOLUTION_FAILURE, this.mc), (Throwable)e);
            return status;
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    private boolean isIndex(ModelCoordinate mc) {
        return Objects.equals(IModelIndex.INDEX.getGroupId(), mc.getGroupId()) && Objects.equals(IModelIndex.INDEX.getArtifactId(), mc.getArtifactId()) && Objects.equals(IModelIndex.INDEX.getClassifier(), mc.getClassifier()) && Objects.equals(IModelIndex.INDEX.getExtension(), mc.getExtension());
    }

    private static final class IndexDownloadFailureDialog
    extends MessageDialogWithToggle {
        private IndexDownloadFailureDialog(Shell parentShell) {
            super(parentShell, Messages.DIALOG_TITLE_INDEX_DOWNLOAD_FAILURE, null, Messages.DIALOG_MESSAGE_INDEX_DOWNLOAD_FAILURE, 1, new String[]{IDialogConstants.OK_LABEL}, 0, Messages.DIALOG_TOGGLE_IGNORE_DOWNLOAD_FAILURES, false);
            this.setPrefStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.models.rcp"));
            this.setPrefKey("ignore.download.failures");
        }

        protected Control createCustomArea(Composite parent) {
            Link link = new Link(parent, 1);
            link.setText(MessageFormat.format(Messages.DIALOG_MESSAGE_INDEX_DOWNLOAD_FAILURE_SUGGESTIONS, "http://eclipse.org/recommenders/faq/", "https://bugs.eclipse.org/bugs/enter_bug.cgi?product=Recommenders"));
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Browsers.openInExternalBrowser((String)event.text);
                }
            });
            return link;
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            try {
                ((ScopedPreferenceStore)this.getPrefStore()).save();
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_SAVE_PREFERENCES_FAILED, (Throwable)e);
            }
        }

        public boolean isIgnored() {
            return this.getPrefStore().getString(this.getPrefKey()).equals("always");
        }
    }
}

