/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.recommenders.internal.models.rcp.DownloadModelArchiveJob;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.DownloadCallback;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.ModelRepository;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Pair;
import org.eclipse.recommenders.utils.Urls;

public class EclipseModelRepository
implements IModelRepository,
IRcpService {
    private final File basedir;
    private final IProxyService proxy;
    private final ModelsRcpPreferences prefs;
    private final EventBus bus;
    private final List<Pair<String, ModelRepository>> delegates = Lists.newLinkedList();
    private boolean isOpen = false;

    @Inject
    public EclipseModelRepository(@Named(value="REPOSITORY_BASEDIR") File basedir, IProxyService proxy, ModelsRcpPreferences prefs, EventBus bus) {
        this.basedir = basedir;
        this.proxy = proxy;
        this.prefs = prefs;
        this.bus = bus;
    }

    @PostConstruct
    void open() throws Exception {
        String[] remoteUrls = this.prefs.remotes;
        LinkedList repositories = Lists.newLinkedList();
        String[] stringArray = remoteUrls;
        int n = remoteUrls.length;
        int n2 = 0;
        while (n2 < n) {
            String remoteUrl = stringArray[n2];
            File cache = new File(this.basedir, Urls.mangle((String)remoteUrl));
            cache.mkdirs();
            repositories.add(Pair.newPair((Object)remoteUrl, (Object)new ModelRepository(cache, remoteUrl)));
            ++n2;
        }
        this.openInternal(repositories);
    }

    @VisibleForTesting
    void openInternal(List<Pair<String, ModelRepository>> repositories) {
        this.delegates.clear();
        this.delegates.addAll(repositories);
        this.isOpen = true;
        this.bus.post((Object)new ModelEvents.ModelRepositoryOpenedEvent());
    }

    @VisibleForTesting
    protected void close() {
        this.closeSilently();
        this.bus.post((Object)new ModelEvents.ModelRepositoryClosedEvent());
    }

    @PreDestroy
    void closeSilently() {
        this.isOpen = false;
    }

    @Subscribe
    public void onModelRepositoryChanged(ModelEvents.ModelRepositoryUrlChangedEvent e) throws Exception {
        this.close();
        this.open();
    }

    private List<ModelRepository> searchDelegates(ModelCoordinate mc) {
        LinkedList result = Lists.newLinkedList();
        String repoUrl = (String)mc.getHint("repository.url").orNull();
        for (Pair<String, ModelRepository> delegate : this.delegates) {
            if (repoUrl != null && !repoUrl.equals(delegate.getFirst())) continue;
            result.add((ModelRepository)delegate.getSecond());
        }
        return result;
    }

    public Optional<File> getLocation(ModelCoordinate mc, boolean prefetch) {
        this.ensureIsOpen();
        List<ModelRepository> foundDelegates = this.searchDelegates(mc);
        for (ModelRepository delegate : foundDelegates) {
            Optional location = delegate.getLocation(mc, false);
            if (prefetch && this.prefs.autoDownloadEnabled) {
                new DownloadModelArchiveJob(this, mc, false, this.bus).schedule();
            }
            if (!location.isPresent()) continue;
            return location;
        }
        return Optional.absent();
    }

    public Optional<File> resolve(ModelCoordinate mc, boolean force) {
        this.ensureIsOpen();
        this.updateProxySettings();
        List<ModelRepository> foundSuitableDelegates = this.searchDelegates(mc);
        for (ModelRepository modelRepository : foundSuitableDelegates) {
            Optional location = modelRepository.resolve(mc, force);
            if (!location.isPresent()) continue;
            return location;
        }
        return Optional.absent();
    }

    public Optional<File> resolve(ModelCoordinate mc, boolean force, DownloadCallback callback) {
        this.ensureIsOpen();
        this.updateProxySettings();
        List<ModelRepository> foundSuitableDelegates = this.searchDelegates(mc);
        for (ModelRepository modelRepository : foundSuitableDelegates) {
            Optional location = modelRepository.resolve(mc, force, callback);
            if (!location.isPresent()) continue;
            return location;
        }
        return Optional.absent();
    }

    private void updateProxySettings() {
        for (Pair<String, ModelRepository> delegate : this.delegates) {
            this.updateProxySettings((String)delegate.getFirst(), (ModelRepository)delegate.getSecond());
        }
    }

    private void updateProxySettings(String repositoryUri, ModelRepository modelRepository) {
        if (!this.proxy.isProxiesEnabled()) {
            modelRepository.unsetProxy();
            return;
        }
        try {
            URI uri = new URI(repositoryUri);
            if (uri.getScheme() == null) {
                return;
            }
            if (uri.getHost() == null) {
                return;
            }
            IProxyData[] entries = this.proxy.select(uri);
            if (entries.length == 0) {
                modelRepository.unsetProxy();
                return;
            }
            IProxyData proxyData = entries[0];
            String type = proxyData.getType().toLowerCase();
            String host = proxyData.getHost();
            int port = proxyData.getPort();
            String userId = proxyData.getUserId();
            String password = proxyData.getPassword();
            modelRepository.setProxy(type, host, port, userId, password);
        }
        catch (URISyntaxException uRISyntaxException) {
            modelRepository.unsetProxy();
        }
    }

    public void deleteModels() throws IOException {
        try {
            this.close();
            FileUtils.cleanDirectory((File)this.basedir);
        }
        finally {
            try {
                this.open();
            }
            catch (Exception e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_OPEN_ECLIPSE_MODEL_REPOSITORY_FOLLOWING_MODEL_DELETION, (Throwable)e);
            }
        }
    }

    private void ensureIsOpen() {
        Checks.ensureIsTrue((boolean)this.isOpen, (String)"model repository service is not accesible at the moment.", (Object[])new Object[0]);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue(this.delegates).toString();
    }
}

