/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.recommenders.internal.news.rcp.Constants;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptors;

@Creatable
public class NewsRcpPreferences
extends AbstractPreferenceInitializer {
    @Inject
    @Preference(value="newsEnabled")
    private boolean enabled;
    @Inject
    @Preference(value="feed.list.sorted")
    private String feeds;
    @Inject
    @Preference(value="custom.feed.list.sorted")
    private String customFeeds;
    @Inject
    @Preference(value="pollingInterval")
    private Long pollingInterval;
    @Inject
    @Preference(value="startupDelay")
    private Long startupDelay;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Long getPollingInterval() {
        return this.pollingInterval;
    }

    public Long getStartupDelay() {
        return this.startupDelay;
    }

    public void initializeDefaultPreferences() {
        IEclipsePreferences s = DefaultScope.INSTANCE.getNode("org.eclipse.recommenders.news.rcp");
        s.putBoolean("newsEnabled", true);
        s.putBoolean("newsNotificationEnabled", false);
        s.putLong("pollingInterval", Constants.DEFAULT_POLLING_INTERVAL);
        s.putLong("startupDelay", Constants.DEFAULT_STARTUP_DELAY);
        s.put("feed.list.sorted", FeedDescriptors.feedsToString(FeedDescriptors.getRegisteredFeeds()));
    }

    public List<FeedDescriptor> getFeedDescriptors() {
        List<FeedDescriptor> feeds = FeedDescriptors.load(this.feeds, FeedDescriptors.getRegisteredFeeds());
        feeds.addAll(FeedDescriptors.getFeeds(this.customFeeds));
        return feeds;
    }
}

