/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.rcp;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.recommenders.internal.utils.rcp.BrowserDialog;
import org.eclipse.recommenders.internal.utils.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.utils.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.osgi.framework.Bundle;

public final class Browsers {
    private static final Bundle BUNDLE = Logs.getBundle(Browsers.class);
    private static final String BUNDLE_SYMBOLIC_NAME = BUNDLE.getSymbolicName();

    private Browsers() {
    }

    public static void openInDefaultBrowser(URL url) {
        MultiStatus multiStatus = new MultiStatus(BUNDLE_SYMBOLIC_NAME, 0, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_DEFAULT_BROWSER, url), null);
        try {
            Status defaultBrowserStatus = Browsers.openInDefaultBrowserImpl(url);
            multiStatus.add((IStatus)defaultBrowserStatus);
            if (defaultBrowserStatus.isOK()) {
                return;
            }
            Status externalBrowserStatus = Browsers.openInExternalBrowserImpl(url);
            multiStatus.add((IStatus)externalBrowserStatus);
            if (externalBrowserStatus.isOK()) {
                return;
            }
            Status osBrowserStatus = Browsers.openInOsBrowserImpl(url);
            multiStatus.add((IStatus)osBrowserStatus);
            if (osBrowserStatus.isOK()) {
                return;
            }
            Status dialogBrowserStatus = Browsers.openInDialogBrowserImpl(url, -1, -1);
            multiStatus.add((IStatus)dialogBrowserStatus);
            if (dialogBrowserStatus.isOK()) {
                return;
            }
        }
        finally {
            if (!multiStatus.isOK()) {
                Platform.getLog((Bundle)BUNDLE).log((IStatus)multiStatus);
            }
        }
    }

    public static void openInDefaultBrowser(String url) {
        try {
            Browsers.openInDefaultBrowser(new URL(url));
        }
        catch (MalformedURLException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_MALFORMED_URI, (Throwable)e, (Object[])new Object[]{url});
        }
    }

    public static void openInExternalBrowser(URL url) {
        MultiStatus multiStatus = new MultiStatus(BUNDLE_SYMBOLIC_NAME, 0, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_EXTERNAL_BROWSER, url), null);
        try {
            Status externalBrowserStatus = Browsers.openInExternalBrowserImpl(url);
            multiStatus.add((IStatus)externalBrowserStatus);
            if (externalBrowserStatus.isOK()) {
                return;
            }
            Status osBrowserStatus = Browsers.openInOsBrowserImpl(url);
            multiStatus.add((IStatus)osBrowserStatus);
            if (osBrowserStatus.isOK()) {
                return;
            }
            Status defaultBrowserStatus = Browsers.openInDefaultBrowserImpl(url);
            multiStatus.add((IStatus)defaultBrowserStatus);
            if (defaultBrowserStatus.isOK()) {
                return;
            }
            Status dialogBrowserStatus = Browsers.openInDialogBrowserImpl(url, -1, -1);
            multiStatus.add((IStatus)dialogBrowserStatus);
            if (dialogBrowserStatus.isOK()) {
                return;
            }
        }
        finally {
            if (!multiStatus.isOK()) {
                Platform.getLog((Bundle)BUNDLE).log((IStatus)multiStatus);
            }
        }
    }

    public static void openInExternalBrowser(String url) {
        try {
            Browsers.openInExternalBrowser(new URL(url));
        }
        catch (MalformedURLException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_MALFORMED_URI, (Throwable)e, (Object[])new Object[]{url});
        }
    }

    public static void openInDialogBrowser(URL url, int width, int height) {
        MultiStatus multiStatus = new MultiStatus(BUNDLE_SYMBOLIC_NAME, 0, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_DIALOG_BROWSER, url), null);
        try {
            Status dialogBrowserStatus = Browsers.openInDialogBrowserImpl(url, width, height);
            multiStatus.add((IStatus)dialogBrowserStatus);
            if (dialogBrowserStatus.isOK()) {
                return;
            }
            Status externalBrowserStatus = Browsers.openInExternalBrowserImpl(url);
            multiStatus.add((IStatus)externalBrowserStatus);
            if (externalBrowserStatus.isOK()) {
                return;
            }
            Status osBrowserStatus = Browsers.openInOsBrowserImpl(url);
            multiStatus.add((IStatus)osBrowserStatus);
            if (osBrowserStatus.isOK()) {
                return;
            }
            Status defaultBrowserStatus = Browsers.openInDefaultBrowserImpl(url);
            multiStatus.add((IStatus)defaultBrowserStatus);
            if (defaultBrowserStatus.isOK()) {
                return;
            }
        }
        finally {
            if (!multiStatus.isOK()) {
                Platform.getLog((Bundle)BUNDLE).log((IStatus)multiStatus);
            }
        }
    }

    public static void openInDialogBrowser(URL url) {
        Browsers.openInDialogBrowser(url, -1, -1);
    }

    public static void openInDialogBrowser(String url) {
        Browsers.openInDialogBrowser(url, -1, -1);
    }

    public static void openInDialogBrowser(String url, int width, int height) {
        try {
            Browsers.openInDialogBrowser(new URL(url), width, height);
        }
        catch (MalformedURLException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_MALFORMED_URI, (Throwable)e, (Object[])new Object[]{url});
        }
    }

    private static Status openInDefaultBrowserImpl(URL url) {
        try {
            IWebBrowser defaultBrowser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(null);
            defaultBrowser.openURL(url);
            return new Status(0, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_INFO_SUCESSFULLY_OPENED_DEFAULT_BROWSER, url));
        }
        catch (PartInitException e) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_DEFAULT_BROWSER, url), (Throwable)e);
        }
    }

    private static Status openInExternalBrowserImpl(URL url) {
        try {
            IWebBrowser externalBrowser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
            externalBrowser.openURL(url);
            return new Status(0, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_INFO_SUCESSFULLY_OPENED_EXTERNAL_BROWSER, url));
        }
        catch (PartInitException e) {
            return new Status(4, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_EXTERNAL_BROWSER, url), (Throwable)e);
        }
    }

    private static Status openInOsBrowserImpl(URL url) {
        boolean success = Program.launch((String)url.toExternalForm());
        if (success) {
            return new Status(0, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_INFO_SUCESSFULLY_OPENED_OS_BROWSER, url));
        }
        return new Status(4, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_OS_BROWSER, url));
    }

    private static Status openInDialogBrowserImpl(URL url, int width, int height) {
        try {
            Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            BrowserDialog browserDialog = width == -1 || height == -1 ? new BrowserDialog(activeShell, url.toExternalForm()) : new BrowserDialog(activeShell, url.toExternalForm(), width, height);
            browserDialog.open();
            return new Status(0, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_INFO_SUCESSFULLY_OPENED_DIALOG_BROWSER, url));
        }
        catch (SWTError e) {
            if (e.code == 2) {
                return new Status(4, BUNDLE_SYMBOLIC_NAME, MessageFormat.format(Messages.LOG_ERROR_FAILED_TO_OPEN_DIALOG_BROWSER, url), (Throwable)e);
            }
            throw e;
        }
    }

    public static void addOpenBrowserAction(Link link) {
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Browsers.openInExternalBrowser(event.text);
            }
        });
    }
}

