/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.snipmatch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.OverlappingFileLockException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.snipmatch.Filenames;
import org.eclipse.recommenders.internal.snipmatch.MultiFieldPrefixQueryParser;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.SearchContext;
import org.eclipse.recommenders.snipmatch.Snippet;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSnippetRepository
implements ISnippetRepository {
    public static final String NO_FILENAME_RESTRICTION = "*no filename restriction*";
    private static final int MAX_SEARCH_RESULTS = 100;
    private static final int CACHE_SIZE = 200;
    private static final Set<String> EMPTY_STOPWORDS = Collections.emptySet();
    private static final String F_NAME = "name";
    private static final String F_DESCRIPTION = "description";
    private static final String F_EXTRA_SEARCH_TERM = "extra";
    private static final String F_TAG = "tag";
    private static final String F_PATH = "path";
    private static final String F_UUID = "uuid";
    private static final String F_LOCATION = "location";
    private static final String F_DEPENDENCY = "dependency";
    private static final String F_FILENAME_RESTRICTION = "filenameRestriction";
    private static final float NAME_BOOST = 4.0f;
    private static final float DESCRIPTION_BOOST = 2.0f;
    private static final float EXTRA_SEARCH_TERM_BOOST = 2.0f;
    private static final float TAG_BOOST = 1.0f;
    private static final float DEPENDENCY_BOOST = 1.0f;
    private static final float NO_RESTRICTION_BOOST = 0.5f;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile int timesOpened = 0;
    private final Lock readLock;
    private final Lock writeLock;
    private final String id;
    private final File snippetsdir;
    private final File indexdir;
    private final String repoUrl;
    private Directory directory;
    private IndexReader reader;
    private final Analyzer analyzer;
    private final QueryParser parser;
    private final Similarity similarity;
    private final LoadingCache<File, Snippet> snippetCache = CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<File, Snippet>(){

        public Snippet load(File file) throws Exception {
            Snippet snippet = (Snippet)GsonUtil.deserialize((File)file, Snippet.class);
            return snippet;
        }
    });

    public FileSnippetRepository(String id, File basedir) {
        Preconditions.checkArgument((boolean)true, (Object)"The cache size needs to be larger than the maximum number of search results.");
        this.id = id;
        this.snippetsdir = new File(basedir, "snippets");
        this.indexdir = new File(basedir, "index");
        this.repoUrl = Urls.mangle((String)basedir.getAbsolutePath());
        this.analyzer = this.createAnalyzer();
        this.parser = this.createParser();
        this.similarity = new IgnoreDocFrequencySimilarity();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    private Analyzer createAnalyzer() {
        StandardAnalyzer standardAnalyzer = new StandardAnalyzer(Version.LUCENE_35, EMPTY_STOPWORDS);
        HashMap analyzers = Maps.newHashMap();
        analyzers.put(F_NAME, standardAnalyzer);
        analyzers.put(F_DESCRIPTION, standardAnalyzer);
        analyzers.put(F_EXTRA_SEARCH_TERM, standardAnalyzer);
        analyzers.put(F_TAG, standardAnalyzer);
        analyzers.put(F_UUID, new KeywordAnalyzer());
        analyzers.put(F_DEPENDENCY, standardAnalyzer);
        return new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer(), (Map)analyzers);
    }

    private QueryParser createParser() {
        String[] searchFields = new String[]{F_NAME, F_DESCRIPTION, F_EXTRA_SEARCH_TERM, F_TAG, F_DEPENDENCY};
        ImmutableMap boosts = ImmutableMap.of((Object)F_NAME, (Object)Float.valueOf(4.0f), (Object)F_DESCRIPTION, (Object)Float.valueOf(2.0f), (Object)F_EXTRA_SEARCH_TERM, (Object)Float.valueOf(2.0f), (Object)F_TAG, (Object)Float.valueOf(1.0f), (Object)F_DEPENDENCY, (Object)Float.valueOf(1.0f));
        MultiFieldPrefixQueryParser parser = new MultiFieldPrefixQueryParser(Version.LUCENE_35, searchFields, this.analyzer, (Map<String, Float>)boosts, F_NAME, F_DESCRIPTION, F_EXTRA_SEARCH_TERM, F_DEPENDENCY);
        parser.setDefaultOperator(QueryParser.Operator.AND);
        return parser;
    }

    public void open() throws IOException {
        this.writeLock.lock();
        try {
            ++this.timesOpened;
            if (this.timesOpened > 1) {
                return;
            }
            this.snippetsdir.mkdirs();
            this.indexdir.mkdirs();
            this.directory = FSDirectory.open((File)this.indexdir);
            this.index();
            this.reader = IndexReader.open((Directory)this.directory);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void index() throws IOException {
        this.writeLock.lock();
        try {
            try {
                File[] snippetFiles = this.snippetsdir.listFiles((FileFilter)new SuffixFileFilter(".json"));
                this.doIndex(snippetFiles);
            }
            catch (OverlappingFileLockException e) {
                throw new IOException(MessageFormat.format("Failure while creating index at \u2018{0}\u2019. Repository was opened {1} times.", this.indexdir, this.timesOpened), e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void doIndex(File[] snippetFiles) throws IOException {
        IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_35, this.analyzer);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try (IndexWriter writer = new IndexWriter(this.directory, config);){
            this.snippetCache.invalidateAll();
            File[] fileArray = snippetFiles;
            int n = snippetFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File snippetFile = fileArray[n2];
                try {
                    ISnippet snippet = (ISnippet)this.snippetCache.get((Object)snippetFile);
                    String path = snippetFile.getPath();
                    this.indexSnippet(writer, snippet, path);
                }
                catch (Exception e) {
                    this.log.error("Failed to index snippet in " + snippetFile, (Throwable)e);
                }
                ++n2;
            }
        }
        if (this.reader != null) {
            this.reader = IndexReader.openIfChanged((IndexReader)this.reader);
        }
    }

    private void indexSnippet(IndexWriter writer, ISnippet snippet, String path) throws IOException {
        Document doc = new Document();
        doc.add((Fieldable)new Field(F_PATH, path, Field.Store.YES, Field.Index.NO));
        doc.add((Fieldable)new Field(F_UUID, snippet.getUuid().toString(), Field.Store.NO, Field.Index.NOT_ANALYZED));
        String name = snippet.getName();
        doc.add((Fieldable)new Field(F_NAME, name, Field.Store.YES, Field.Index.ANALYZED));
        String description = snippet.getDescription();
        doc.add((Fieldable)new Field(F_DESCRIPTION, description, Field.Store.YES, Field.Index.ANALYZED));
        for (String tag : snippet.getTags()) {
            doc.add((Fieldable)new Field(F_TAG, tag, Field.Store.YES, Field.Index.ANALYZED_NO_NORMS));
        }
        for (String extraSearchTerm : snippet.getExtraSearchTerms()) {
            doc.add((Fieldable)new Field(F_EXTRA_SEARCH_TERM, extraSearchTerm, Field.Store.YES, Field.Index.ANALYZED));
        }
        for (Location location : this.expandLocation(snippet.getLocation())) {
            Field field = new Field(F_LOCATION, this.getIndexString(location), Field.Store.NO, Field.Index.NOT_ANALYZED);
            field.setBoost(0.0f);
            doc.add((Fieldable)field);
        }
        for (ProjectCoordinate dependency : snippet.getNeededDependencies()) {
            doc.add((Fieldable)new Field(F_DEPENDENCY, this.getDependencyString(dependency), Field.Store.YES, Field.Index.ANALYZED));
        }
        if (snippet.getLocation() == Location.FILE) {
            if (snippet.getFilenameRestrictions().isEmpty()) {
                doc.add((Fieldable)new Field(F_FILENAME_RESTRICTION, NO_FILENAME_RESTRICTION, Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
            for (String restriction : snippet.getFilenameRestrictions()) {
                doc.add((Fieldable)new Field(F_FILENAME_RESTRICTION, restriction.toLowerCase(), Field.Store.NO, Field.Index.NOT_ANALYZED));
            }
        } else {
            doc.add((Fieldable)new Field(F_FILENAME_RESTRICTION, NO_FILENAME_RESTRICTION, Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        writer.addDocument(doc);
    }

    private String getDependencyString(ProjectCoordinate pc) {
        return String.valueOf(pc.getGroupId()) + ":" + pc.getArtifactId();
    }

    private String getIndexString(Location location) {
        return location.name().toLowerCase().replace('_', '-');
    }

    @VisibleForTesting
    public boolean isOpen() {
        return this.timesOpened > 0;
    }

    private ISnippet getSnippet(File snippetFile) {
        try {
            return (ISnippet)this.snippetCache.get((Object)snippetFile);
        }
        catch (Exception e) {
            this.log.error("Error while loading snippet from file {}", (Object)snippetFile.getAbsolutePath(), (Object)e);
            return null;
        }
    }

    @Override
    public List<Recommendation<ISnippet>> search(ISearchContext context) {
        return this.doSearch(context, Integer.MAX_VALUE);
    }

    @Override
    public List<Recommendation<ISnippet>> search(ISearchContext context, int maxResults) {
        if (StringUtils.isBlank((CharSequence)context.getSearchText())) {
            return Collections.emptyList();
        }
        return this.doSearch(context, Math.min(maxResults, 100));
    }

    private List<Recommendation<ISnippet>> doSearch(ISearchContext context, int maxResults) {
        this.readLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen());
            LinkedList results = Lists.newLinkedList();
            try {
                Map<File, Float> snippetFiles = this.searchSnippetFiles(context, maxResults);
                for (Map.Entry<File, Float> entry : snippetFiles.entrySet()) {
                    ISnippet snippet = (ISnippet)this.snippetCache.get((Object)entry.getKey());
                    results.add(Recommendation.newRecommendation((Object)snippet, (double)entry.getValue().floatValue()));
                }
            }
            catch (Exception e) {
                this.log.error("Exception occurred while searching the snippet index.", (Throwable)e);
            }
            LinkedList linkedList = results;
            return linkedList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * Loose catch block
     */
    private Map<File, Float> searchSnippetFiles(ISearchContext context, int maxResults) {
        LinkedHashMap results;
        block15: {
            Map<File, Float> map;
            results = Maps.newLinkedHashMap();
            IndexSearcher searcher = null;
            try {
                String filename;
                BooleanQuery query = new BooleanQuery();
                if (StringUtils.isBlank((CharSequence)context.getSearchText())) {
                    query.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
                } else {
                    query.add(this.parser.parse(context.getSearchText()), BooleanClause.Occur.MUST);
                }
                if (context.getLocation() != Location.NONE) {
                    query.add((Query)new TermQuery(new Term(F_LOCATION, this.getIndexString(context.getLocation()))), BooleanClause.Occur.MUST);
                }
                if ((filename = context.getFilename()) != null) {
                    BooleanQuery filenameRestrictionsQuery = new BooleanQuery();
                    TermQuery noRestrictionQuery = new TermQuery(new Term(F_FILENAME_RESTRICTION, NO_FILENAME_RESTRICTION));
                    noRestrictionQuery.setBoost(0.5f);
                    filenameRestrictionsQuery.add((Query)noRestrictionQuery, BooleanClause.Occur.SHOULD);
                    int i = 1;
                    for (String restriction : Filenames.getFilenameRestrictions(filename)) {
                        TermQuery restrictionQuery = new TermQuery(new Term(F_FILENAME_RESTRICTION, restriction.toLowerCase()));
                        float boost = (float)(0.5 + Math.pow(0.5, i));
                        restrictionQuery.setBoost(boost);
                        filenameRestrictionsQuery.add((Query)restrictionQuery, BooleanClause.Occur.SHOULD);
                        ++i;
                    }
                    query.add((Query)filenameRestrictionsQuery, BooleanClause.Occur.MUST);
                }
                searcher = new IndexSearcher(this.reader);
                searcher.setSimilarity(this.similarity);
                float maxScore = 0.0f;
                ScoreDoc[] scoreDocArray = searcher.search((Query)query, null, (int)maxResults).scoreDocs;
                int n = searcher.search((Query)query, null, (int)maxResults).scoreDocs.length;
                int n2 = 0;
                while (n2 < n) {
                    Object hit = scoreDocArray[n2];
                    Document doc = searcher.doc(((ScoreDoc)hit).doc);
                    if (this.snippetApplicable(doc, context)) {
                        results.put(new File(doc.get(F_PATH)), Float.valueOf(((ScoreDoc)hit).score));
                        if (((ScoreDoc)hit).score > maxScore) {
                            maxScore = ((ScoreDoc)hit).score;
                        }
                    }
                    ++n2;
                }
                map = this.normalizeValues(results, maxScore);
                IOUtils.closeQuietly((Closeable)searcher);
            }
            catch (ParseException e) {
                this.log.info("Failed to parse query", (Throwable)e);
                break block15;
            }
            catch (Exception e2) {
                this.log.error("Exception occurred while searching the snippet index.", (Throwable)e2);
                break block15;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly(searcher);
            }
            return map;
        }
        return results;
    }

    private boolean snippetApplicable(Document doc, ISearchContext context) {
        String[] snippetDependencies;
        if (!context.isRestrictedByDependencies()) {
            return true;
        }
        String[] stringArray = snippetDependencies = doc.getValues(F_DEPENDENCY);
        int n = snippetDependencies.length;
        int n2 = 0;
        while (n2 < n) {
            String snippetDependency = stringArray[n2];
            boolean applicable = false;
            for (ProjectCoordinate workspaceDependency : context.getDependencies()) {
                if (!this.applicable(workspaceDependency, snippetDependency)) continue;
                applicable = true;
                break;
            }
            if (!applicable) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean applicable(ProjectCoordinate pc, String dependency) {
        return this.getDependencyString(pc).equals(dependency);
    }

    private Collection<Location> expandLocation(Location location) {
        switch (location) {
            case JAVA_STATEMENTS: {
                return ImmutableSet.of((Object)((Object)Location.JAVA_STATEMENTS));
            }
            case JAVA_TYPE_MEMBERS: {
                return ImmutableSet.of((Object)((Object)Location.JAVA_TYPE_MEMBERS));
            }
            case JAVADOC: {
                return ImmutableSet.of((Object)((Object)Location.JAVADOC));
            }
            case JAVA: {
                return ImmutableSet.of((Object)((Object)Location.JAVA), (Object)((Object)Location.JAVA_STATEMENTS), (Object)((Object)Location.JAVA_TYPE_MEMBERS));
            }
            case JAVA_FILE: {
                return ImmutableSet.of((Object)((Object)Location.JAVA_FILE), (Object)((Object)Location.JAVADOC), (Object)((Object)Location.JAVA), (Object)((Object)Location.JAVA_STATEMENTS), (Object)((Object)Location.JAVA_TYPE_MEMBERS));
            }
            case FILE: {
                return ImmutableSet.of((Object)((Object)Location.FILE), (Object)((Object)Location.JAVA_FILE), (Object)((Object)Location.JAVADOC), (Object)((Object)Location.JAVA), (Object)((Object)Location.JAVA_STATEMENTS), (Object)((Object)Location.JAVA_TYPE_MEMBERS), (Object[])new Location[0]);
            }
        }
        throw new IllegalArgumentException(location.toString());
    }

    private Map<File, Float> normalizeValues(Map<File, Float> results, final float maxScore) {
        return Maps.transformValues(results, (Function)new Function<Float, Float>(){

            public Float apply(Float input) {
                return Float.valueOf(maxScore == 0.0f ? 1.0f : input.floatValue() / maxScore);
            }
        });
    }

    @Override
    public boolean hasSnippet(UUID uuid) {
        this.readLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen());
            boolean bl = !this.searchSnippetFiles(new SearchContext("uuid:" + uuid), Integer.MAX_VALUE).isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean delete(UUID uuid) throws IOException {
        this.writeLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen());
            Map<File, Float> snippetFiles = this.searchSnippetFiles(new SearchContext("uuid:" + uuid), Integer.MAX_VALUE);
            if (snippetFiles.isEmpty()) {
                return false;
            }
            ((File)Iterables.getOnlyElement(snippetFiles.keySet())).delete();
            this.index();
            return true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isDeleteSupported() {
        return true;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getRepositoryLocation() {
        return this.repoUrl;
    }

    @Override
    public void close() {
        this.writeLock.lock();
        try {
            if (this.timesOpened == 0) {
                return;
            }
            if (this.timesOpened > 1) {
                --this.timesOpened;
                return;
            }
            if (this.timesOpened == 1) {
                this.timesOpened = 0;
                IOUtils.closeQuietly((Closeable)this.reader);
                IOUtils.closeQuietly((Closeable)this.directory);
                this.reader = null;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void importSnippet(ISnippet snippet) throws IOException {
        this.writeLock.lock();
        try {
            Preconditions.checkState((boolean)this.isOpen());
            Snippet importSnippet = this.checkTypeAndConvertSnippet(snippet);
            Map<File, Float> snippetFiles = this.searchSnippetFiles(new SearchContext("uuid:" + importSnippet.getUuid()), Integer.MAX_VALUE);
            File file = snippetFiles.isEmpty() ? new File(this.snippetsdir, importSnippet.getUuid() + ".json") : (File)Iterables.getOnlyElement(snippetFiles.keySet());
            FileWriter writer = new FileWriter(file);
            writer.write(GsonUtil.serialize((Object)importSnippet));
            writer.flush();
            writer.close();
            this.index();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isImportSupported() {
        return true;
    }

    private Snippet checkTypeAndConvertSnippet(ISnippet snippet) {
        if (snippet instanceof Snippet) {
            return (Snippet)snippet;
        }
        return Snippet.copy(snippet);
    }

    @Override
    public boolean delete() {
        this.writeLock.lock();
        try {
            this.close();
            try {
                FileUtils.deleteDirectory((File)this.snippetsdir);
                FileUtils.deleteDirectory((File)this.indexdir);
                return true;
            }
            catch (IOException iOException) {
                this.writeLock.unlock();
                return false;
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean share(Collection<UUID> uuids) {
        return false;
    }

    @Override
    public boolean isSharingSupported() {
        return false;
    }

    public ISnippet getSnippet(UUID uuid) {
        File snippetFile = this.getSnippetFile(uuid);
        if (snippetFile == null) {
            return null;
        }
        return this.getSnippet(snippetFile);
    }

    public File getSnippetFile(UUID uuid) {
        this.readLock.lock();
        try {
            File file = new File(this.snippetsdir, String.valueOf(uuid.toString()) + ".json");
            File file2 = file.exists() ? file : null;
            return file2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class IgnoreDocFrequencySimilarity
    extends DefaultSimilarity {
        private static final long serialVersionUID = 6048878092975074153L;

        private IgnoreDocFrequencySimilarity() {
        }

        public float tf(float freq) {
            return 1.0f;
        }

        public float idf(int docFreq, int numDocs) {
            return 1.0f;
        }
    }
}

