/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jdt.templates;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.recommenders.internal.jdt.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public class SnippetCodeBuilder {
    private final CompilationUnit ast;
    private final ASTNode startNode;
    private final IDocument document;
    private final IRegion textSelection;
    private final Map<ASTNode, String> nodesToReplace;
    private final Set<String> imports = new TreeSet<String>();
    private final Set<String> importStatics = new TreeSet<String>();
    private final HashMap<IVariableBinding, String> templateVariableNameReferences = new HashMap();
    private final HashSet<String> assignedTemplateVariablesNames = new HashSet();
    private final HashMap<String, Integer> lastTemplateVariableIndex = new HashMap();
    private final StringBuilder code = new StringBuilder();

    public SnippetCodeBuilder(CompilationUnit ast, IDocument document, IRegion textSelection) {
        this(ast, document, textSelection, Collections.emptyMap());
    }

    public SnippetCodeBuilder(CompilationUnit ast, IDocument document, IRegion textSelection, Map<ASTNode, String> nodesToReplace) {
        this(ast, (ASTNode)ast, document, textSelection, nodesToReplace);
    }

    public SnippetCodeBuilder(ASTNode startNode, IDocument document, IRegion textSelection) {
        this(startNode, document, textSelection, Collections.emptyMap());
    }

    public SnippetCodeBuilder(ASTNode startNode, IDocument document, IRegion textSelection, Map<ASTNode, String> nodesToReplace) {
        this((CompilationUnit)startNode.getRoot(), startNode, document, textSelection, nodesToReplace);
    }

    private SnippetCodeBuilder(CompilationUnit ast, ASTNode startNode, IDocument document, IRegion textSelection, Map<ASTNode, String> nodesToReplace) {
        this.ast = Objects.requireNonNull(ast);
        this.startNode = Objects.requireNonNull(startNode);
        this.document = Objects.requireNonNull(document);
        this.textSelection = Objects.requireNonNull(textSelection);
        this.nodesToReplace = Objects.requireNonNull(nodesToReplace);
    }

    /*
     * Unable to fully structure code
     */
    public String build() {
        start = this.textSelection.getOffset();
        length = this.textSelection.getLength();
        try {
            text = this.document.get(start, length);
        }
        catch (BadLocationException e) {
            javaElement = this.ast.getJavaElement();
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_GET_TEXT_SELECTION, (Throwable)e, (Object[])new Object[]{javaElement == null ? null : javaElement.getHandleIdentifier(), start, length});
            return "";
        }
        if (text == null) {
            javaElement = this.ast.getJavaElement();
            Logs.log((Logs.ILogMessage)LogMessages.WARN_FAILED_TO_GET_TEXT_SELECTION, (Object[])new Object[]{javaElement == null ? null : javaElement.getHandleIdentifier(), start, length});
            return "";
        }
        chars = text.toCharArray();
        enclosingNode = NodeFinder.perform((ASTNode)this.startNode, (int)start, (int)length);
        i = 0;
        while (i < chars.length) {
            block34: {
                block35: {
                    offset = start + i;
                    for (Map.Entry<ASTNode, String> entry : this.nodesToReplace.entrySet()) {
                        nodeToReplace = entry.getKey();
                        preferredName = entry.getValue();
                        if (offset != nodeToReplace.getStartPosition() || nodeToReplace.getStartPosition() + nodeToReplace.getLength() > offset + chars.length) continue;
                        if (!(nodeToReplace instanceof Expression)) {
                            this.appendTemplateVariableReference(preferredName);
                            i += nodeToReplace.getLength() - 1;
                        } else {
                            expressionToReplace = (Expression)nodeToReplace;
                            typeBinding = expressionToReplace.resolveTypeBinding();
                            if (typeBinding == null) {
                                this.appendTemplateVariableReference(preferredName);
                                i += nodeToReplace.getLength() - 1;
                            } else {
                                templateVariableName = this.createTemplateVariableName(preferredName);
                                if (!this.appendTypedTemplateVariableInternal(templateVariableName, "var", typeBinding)) {
                                    this.appendTemplateVariableReference(templateVariableName);
                                    i += nodeToReplace.getLength() - 1;
                                } else {
                                    i += nodeToReplace.getLength() - 1;
                                }
                            }
                        }
                        break block34;
                    }
                    c = chars[i];
                    if (Character.isJavaIdentifierPart(c)) break block35;
                    this.code.append(c);
                    break block34;
                }
                nodeFinder = new NodeFinder(enclosingNode, offset, 0);
                node = nodeFinder.getCoveringNode();
                if (!this.isCoveredBySelection(node)) ** GOTO lbl-1000
                block1 : switch (node.getNodeType()) {
                    case 42: {
                        name = (SimpleName)node;
                        binding = name.resolveBinding();
                        if (binding != null) {
                            switch (binding.getKind()) {
                                case 2: {
                                    typeBinding = (ITypeBinding)binding;
                                    if (this.isUnqualified(name) && !this.isDeclaredInSelection((IBinding)typeBinding)) {
                                        this.rememberImport(typeBinding);
                                    }
                                    this.code.append(name);
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                                case 4: {
                                    methodBinding = (IMethodBinding)binding;
                                    if (this.isUnqualifiedMethodInvocation(name) && this.isStatic((IBinding)methodBinding) && !this.isDeclaredInSelection((IBinding)methodBinding)) {
                                        this.rememberStaticImport(methodBinding);
                                    }
                                    this.code.append(name);
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                                case 3: {
                                    variableBinding = (IVariableBinding)binding;
                                    if (this.isDeclaration(name)) {
                                        if (!this.appendNewNameTemplateVariable(name.getIdentifier(), variableBinding)) {
                                            this.code.append(name);
                                        }
                                    } else if (this.isDeclaredInSelection((IBinding)variableBinding)) {
                                        this.appendTemplateVariableReference(variableBinding);
                                    } else if (!this.isUnqualified(name)) {
                                        this.code.append(name);
                                    } else if (variableBinding.isField()) {
                                        if (this.isStatic((IBinding)variableBinding)) {
                                            this.code.append(name);
                                            this.rememberStaticImport(variableBinding);
                                        } else if (!this.appendFieldTemplateVariable(name.getIdentifier(), variableBinding)) {
                                            this.code.append(name);
                                        }
                                    } else {
                                        this.appendVarTemplateVariable(name.getIdentifier(), variableBinding);
                                    }
                                    i += name.getLength() - 1;
                                    break block1;
                                }
                            }
                        }
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        this.code.append(c);
                        if (c != '$') break;
                        this.code.append(c);
                    }
                }
            }
            ++i;
        }
        this.code.append('\n');
        this.appendImportTemplateVariable();
        this.appendImportStaticTemplateVariable();
        this.appendCursorTemplateVariable();
        this.replaceLeadingWhitespaces();
        return this.code.toString();
    }

    public boolean isCoveredBySelection(ASTNode node) {
        int nodeStart = node.getStartPosition();
        int nodeEnd = nodeStart + node.getLength();
        return this.textSelection.getOffset() <= nodeStart && nodeEnd <= this.textSelection.getOffset() + this.textSelection.getLength();
    }

    private boolean isDeclaredInSelection(IBinding binding) {
        ASTNode declaringNode = this.ast.findDeclaringNode(binding);
        if (declaringNode == null) {
            return false;
        }
        return this.isCoveredBySelection(declaringNode);
    }

    private boolean isUnqualified(SimpleName name) {
        return !QualifiedName.NAME_PROPERTY.equals(name.getLocationInParent());
    }

    private boolean isUnqualifiedMethodInvocation(SimpleName name) {
        if (!MethodInvocation.NAME_PROPERTY.equals(name.getLocationInParent())) {
            return false;
        }
        MethodInvocation methodInvocation = (MethodInvocation)name.getParent();
        return methodInvocation.getExpression() == null;
    }

    private boolean isStatic(IBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private boolean isDeclaration(SimpleName name) {
        if (VariableDeclarationFragment.NAME_PROPERTY.equals(name.getLocationInParent())) {
            return true;
        }
        return SingleVariableDeclaration.NAME_PROPERTY.equals(name.getLocationInParent());
    }

    private void rememberImport(ITypeBinding binding) {
        if (binding.isArray()) {
            this.rememberImport(binding.getComponentType());
            return;
        }
        IPackageBinding packageBinding = binding.getPackage();
        if (packageBinding == null) {
            return;
        }
        if (packageBinding.isUnnamed()) {
            return;
        }
        if (packageBinding.getName().equals("java.lang")) {
            return;
        }
        ITypeBinding erasure = binding.getErasure();
        if (erasure.isRecovered()) {
            return;
        }
        this.imports.add(erasure.getQualifiedName());
    }

    private void rememberStaticImport(IMethodBinding method) {
        Preconditions.checkArgument((boolean)this.isStatic((IBinding)method));
        this.rememberStaticImport(method.getDeclaringClass(), method.getName());
    }

    private void rememberStaticImport(IVariableBinding field) {
        Preconditions.checkArgument((boolean)field.isField());
        Preconditions.checkArgument((boolean)this.isStatic((IBinding)field));
        this.rememberStaticImport(field.getDeclaringClass(), field.getName());
    }

    private void rememberStaticImport(ITypeBinding declaringTypeBinding, String member) {
        if (declaringTypeBinding == null) {
            return;
        }
        IPackageBinding packageBinding = declaringTypeBinding.getPackage();
        if (packageBinding == null) {
            return;
        }
        if (packageBinding.isUnnamed()) {
            return;
        }
        this.importStatics.add(String.valueOf(declaringTypeBinding.getErasure().getQualifiedName()) + '.' + member);
    }

    private boolean appendTemplateVariableReference(String preferredName) {
        String templateVariableName = this.createTemplateVariableName(preferredName);
        this.code.append('$').append('{').append(templateVariableName).append('}');
        return true;
    }

    private boolean appendTemplateVariableReference(IVariableBinding variableBinding) {
        String templateVariableName = (String)this.findTemplateVariableName(variableBinding).orNull();
        if (templateVariableName != null) {
            this.code.append('$').append('{').append(templateVariableName).append('}');
            return true;
        }
        return false;
    }

    private boolean appendNewNameTemplateVariable(String preferredName, IVariableBinding variableBinding) {
        if (this.appendTemplateVariableReference(variableBinding)) {
            return true;
        }
        String templateVariableName = this.createTemplateVariableName(preferredName, variableBinding);
        ITypeBinding type = variableBinding.getType();
        return this.appendTypedTemplateVariableInternal(templateVariableName, "newName", type);
    }

    private boolean appendFieldTemplateVariable(String preferredName, IVariableBinding variableBinding) {
        Preconditions.checkArgument((boolean)variableBinding.isField());
        if (this.appendTemplateVariableReference(variableBinding)) {
            return true;
        }
        String templateVariableName = this.createTemplateVariableName(preferredName, variableBinding);
        ITypeBinding typeBinding = variableBinding.getType();
        return this.appendTypedTemplateVariableInternal(templateVariableName, "field", typeBinding);
    }

    private boolean appendVarTemplateVariable(String preferredName, IVariableBinding variableBinding) {
        Preconditions.checkArgument((!variableBinding.isField() ? 1 : 0) != 0);
        if (this.appendTemplateVariableReference(variableBinding)) {
            return true;
        }
        String templateVariableName = this.createTemplateVariableName(preferredName, variableBinding);
        ITypeBinding typeBinding = variableBinding.getType();
        return this.appendTypedTemplateVariableInternal(templateVariableName, "var", typeBinding);
    }

    private boolean appendTypedTemplateVariableInternal(String templateVariableName, String kind, ITypeBinding typeBinding) {
        if (typeBinding == null) {
            return false;
        }
        ITypeBinding erasure = typeBinding.getErasure();
        if (erasure == null) {
            return false;
        }
        if (erasure.isRecovered()) {
            return false;
        }
        this.code.append('$').append('{').append(templateVariableName).append(':').append(kind).append('(');
        if (typeBinding.isArray()) {
            this.code.append('\'').append(erasure.getQualifiedName()).append('\'');
        } else {
            this.code.append(erasure.getQualifiedName());
        }
        this.code.append(')').append('}');
        return true;
    }

    private Optional<String> findTemplateVariableName(IVariableBinding variable) {
        return Optional.fromNullable((Object)this.templateVariableNameReferences.get(variable));
    }

    private String createTemplateVariableName(String preferredName, IVariableBinding variableBinding) {
        Preconditions.checkState((!this.templateVariableNameReferences.containsKey(variableBinding) ? 1 : 0) != 0);
        String assignedName = this.createTemplateVariableName(preferredName);
        this.templateVariableNameReferences.put(variableBinding, assignedName);
        return assignedName;
    }

    private String createTemplateVariableName(String preferredName) {
        String sanitizedPreferredName = preferredName.replace('$', '_');
        String candidateName = sanitizedPreferredName;
        Integer i = this.lastTemplateVariableIndex.containsKey(candidateName) ? this.lastTemplateVariableIndex.get(candidateName) : Integer.valueOf(1);
        while (this.assignedTemplateVariablesNames.contains(candidateName)) {
            Integer n = i;
            i = n + 1;
            candidateName = sanitizedPreferredName.concat(Integer.toString(n));
        }
        String assignedName = candidateName;
        this.assignedTemplateVariablesNames.add(assignedName);
        this.lastTemplateVariableIndex.put(assignedName, i);
        return assignedName;
    }

    private boolean appendImportTemplateVariable() {
        return this.appendStringTemplateVariableInternal("import", this.imports);
    }

    private boolean appendImportStaticTemplateVariable() {
        return this.appendStringTemplateVariableInternal("importStatic", this.importStatics);
    }

    private boolean appendStringTemplateVariableInternal(String kind, Collection<String> imports) {
        if (imports.isEmpty()) {
            return false;
        }
        String joinedImports = Joiner.on((String)", ").join(imports);
        this.code.append('$').append('{').append(':').append(kind).append('(').append(joinedImports).append(')').append('}');
        return true;
    }

    private void appendCursorTemplateVariable() {
        this.code.append("${cursor}");
    }

    private void replaceLeadingWhitespaces() {
        try {
            IRegion firstLineInfo = this.document.getLineInformationOfOffset(this.textSelection.getOffset());
            String line = this.document.get(firstLineInfo.getOffset(), firstLineInfo.getLength());
            int index = 0;
            while (index < line.length()) {
                if (!Character.isWhitespace(line.charAt(index))) break;
                ++index;
            }
            String wsPrefix = line.substring(0, index);
            String[] lines = this.code.toString().split("\\r?\\n");
            this.code.setLength(0);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                String clean = StringUtils.removeStart((String)l, (String)wsPrefix);
                this.code.append(clean).append(SystemUtils.LINE_SEPARATOR);
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_SNIPPET_REPLACE_LEADING_WHITESPACE_FAILED, (Throwable)e);
        }
    }
}

