/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.eclipse.recommenders.utils.LogMessages;
import org.eclipse.recommenders.utils.Logs;

public final class MethodHandleUtils {
    private MethodHandleUtils() {
    }

    public static Optional<MethodHandle> getSuperMethodHandle(MethodHandles.Lookup lookupCapability, String methodName, Class<?> returnType, Class<?> ... argumentTypes) {
        return MethodHandleUtils.getSuperMethodHandle(false, lookupCapability, methodName, returnType, argumentTypes);
    }

    public static Optional<MethodHandle> getSuperMethodHandle(boolean isFunctionalityLimitedOnFailure, MethodHandles.Lookup lookupCapability, String methodName, Class<?> returnType, Class<?> ... argumentTypes) {
        try {
            Class<?> callerClass = lookupCapability.lookupClass();
            Class<?> superclass = callerClass.getSuperclass();
            return Optional.of((Object)lookupCapability.findSpecial(superclass, methodName, MethodType.methodType(returnType, argumentTypes), callerClass));
        }
        catch (NoSuchMethodException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED_LIMITED_FUNCTIONALITY, e, methodName);
            }
            return Optional.absent();
        }
        catch (IllegalAccessException e) {
            if (isFunctionalityLimitedOnFailure) {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED_LIMITED_FUNCTIONALITY, e, methodName);
            } else {
                Logs.log((Logs.ILogMessage)LogMessages.LOG_WARNING_REFLECTION_FAILED, e, methodName);
            }
            return Optional.absent();
        }
    }
}

