/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchInputValidator;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.util.RepositoryUrlValidator;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.ISnippetRepositoryWizard;
import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelFactory;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GitBasedRepositoryConfigurationWizard
extends Wizard
implements ISnippetRepositoryWizard {
    private static final List<String> REPOSITORY_OPTIONS = ImmutableList.of((Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_GIT_PUSH_BRANCH_PREFIX, (Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_GERRIT_PUSH_BRANCH_PREFIX, (Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX);
    private final BranchInputValidator branchInputValidator = new BranchInputValidator();
    private final Repositories repositories;
    private GitBasedRepositoryConfigurationWizardPage page = new GitBasedRepositoryConfigurationWizardPage(Messages.WIZARD_GIT_REPOSITORY_PAGE_NAME);
    private EclipseGitSnippetRepositoryConfiguration configuration;
    private static final List<String> PUSH_BRANCH_PREFIXES = ImmutableList.of((Object)"refs/heads", (Object)"refs/for");

    @Inject
    public GitBasedRepositoryConfigurationWizard(Repositories repositories) {
        this.repositories = repositories;
        this.setWindowTitle(Messages.WIZARD_GIT_REPOSITORY_WINDOW_TITLE);
        this.page.setWizard(this);
        this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/add_git_repository.png"));
    }

    public boolean performFinish() {
        this.configuration = SnipmatchRcpModelFactory.eINSTANCE.createEclipseGitSnippetRepositoryConfiguration();
        this.configuration.setName(this.page.txtName.getText());
        this.configuration.setUrl(this.page.txtFetchUri.getText());
        this.configuration.setPushUrl(this.page.txtPushUri.getText());
        this.configuration.setPushBranchPrefix(this.page.txtPushBranchPrefix.getText());
        return true;
    }

    @Override
    public SnippetRepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public IWizardPage getStartingPage() {
        return this.page;
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    @Override
    public boolean isApplicable(SnippetRepositoryConfiguration configuration) {
        return configuration instanceof EclipseGitSnippetRepositoryConfiguration;
    }

    @Override
    public void setConfiguration(SnippetRepositoryConfiguration configuration) {
        this.configuration = (EclipseGitSnippetRepositoryConfiguration)Checks.cast((Object)configuration);
        if (configuration != null) {
            this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/edit_git_repository.png"));
            this.page.setDescription(Messages.WIZARD_GIT_REPOSITORY_EDIT_DESCRIPTION);
        }
    }

    class GitBasedRepositoryConfigurationWizardPage
    extends WizardPage {
        private Text txtName;
        private Text txtFetchUri;
        private Text txtPushUri;
        private Text txtPushBranchPrefix;
        private Combo cmbPushBranchRepository;

        protected GitBasedRepositoryConfigurationWizardPage(String pageName) {
            super(pageName);
            this.setTitle(Messages.WIZARD_GIT_REPOSITORY_TITLE);
            this.setDescription(Messages.WIZARD_GIT_REPOSITORY_ADD_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(3).applyTo(container);
            Label lblName = new Label(container, 0);
            lblName.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_NAME);
            this.txtName = new Text(container, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.txtName);
            this.txtName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            this.addFetchGroup(container);
            this.addPushGroup(container);
            if (GitBasedRepositoryConfigurationWizard.this.configuration != null) {
                this.txtName.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getName());
                this.txtFetchUri.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getUrl());
                this.txtPushUri.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getPushUrl());
                String pushBranchPrefix = GitBasedRepositoryConfigurationWizard.this.configuration.getPushBranchPrefix();
                if (PUSH_BRANCH_PREFIXES.contains(pushBranchPrefix)) {
                    this.cmbPushBranchRepository.select(PUSH_BRANCH_PREFIXES.indexOf(pushBranchPrefix));
                    this.txtPushBranchPrefix.setText(pushBranchPrefix);
                    this.txtPushBranchPrefix.setEnabled(false);
                } else {
                    this.cmbPushBranchRepository.select(REPOSITORY_OPTIONS.indexOf(Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX));
                    this.txtPushBranchPrefix.setText(pushBranchPrefix);
                    this.txtPushBranchPrefix.setEnabled(true);
                }
            } else {
                this.cmbPushBranchRepository.select(0);
                this.txtPushBranchPrefix.setText((String)PUSH_BRANCH_PREFIXES.get(0));
                this.txtPushBranchPrefix.setEnabled(false);
            }
            this.txtName.forceFocus();
            this.setControl((Control)container);
            this.updatePageComplete();
        }

        private void addFetchGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_FETCH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(2).applyTo((Composite)group);
            Label lblFetchUri = new Label((Composite)group, 0);
            lblFetchUri.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_FETCH_URL);
            this.txtFetchUri = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.txtFetchUri);
            this.txtFetchUri.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
        }

        private void addPushGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_PUSH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(4).applyTo((Composite)group);
            Label lblPushUri = new Label((Composite)group, 0);
            lblPushUri.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_URL);
            this.txtPushUri = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.txtPushUri);
            this.txtPushUri.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label lblPushSettingsDescription = new Label((Composite)group, 64);
            lblPushSettingsDescription.setLayoutData((Object)GridDataFactory.swtDefaults().span(4, 1).align(4, 1).grab(true, false).hint(super.convertHorizontalDLUsToPixels(300), -1).create());
            lblPushSettingsDescription.setText(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_PUSH_SETTINGS_DESCRIPTION, "format-5"));
            Label lblPushBranchPrefix = new Label((Composite)group, 0);
            lblPushBranchPrefix.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_BRANCH_PREFIX);
            this.cmbPushBranchRepository = new Combo((Composite)group, 12);
            this.cmbPushBranchRepository.setItems(REPOSITORY_OPTIONS.toArray(new String[REPOSITORY_OPTIONS.size()]));
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.cmbPushBranchRepository);
            this.cmbPushBranchRepository.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (GitBasedRepositoryConfigurationWizardPage.this.cmbPushBranchRepository.getText().equals(Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX)) {
                        GitBasedRepositoryConfigurationWizardPage.this.txtPushBranchPrefix.setText("");
                        GitBasedRepositoryConfigurationWizardPage.this.txtPushBranchPrefix.setEnabled(true);
                    } else {
                        GitBasedRepositoryConfigurationWizardPage.this.txtPushBranchPrefix.setText((String)PUSH_BRANCH_PREFIXES.get(GitBasedRepositoryConfigurationWizardPage.this.cmbPushBranchRepository.getSelectionIndex()));
                        GitBasedRepositoryConfigurationWizardPage.this.txtPushBranchPrefix.setEnabled(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.txtPushBranchPrefix = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.txtPushBranchPrefix);
            this.txtPushBranchPrefix.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label lblBranch = new Label((Composite)group, 0);
            lblBranch.setText("/format-5");
        }

        public void updatePageComplete() {
            this.setErrorMessage(null);
            String pushBranchPrefixValid = GitBasedRepositoryConfigurationWizard.this.branchInputValidator.isValid(this.txtPushBranchPrefix.getText());
            IStatus fetchUriValidation = RepositoryUrlValidator.isValidUri(this.txtFetchUri.getText());
            IStatus pushUriValidation = RepositoryUrlValidator.isValidUri(this.txtPushUri.getText());
            if (Strings.isNullOrEmpty((String)this.txtName.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_NAME);
            } else if (!fetchUriValidation.isOK()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_FETCH_URI, fetchUriValidation.getMessage()));
            } else if (this.isUriAlreadyAdded(this.txtFetchUri.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_FETCH_URI_ALREADY_ADDED);
            } else if (!pushUriValidation.isOK()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_PUSH_URI, pushUriValidation.getMessage()));
            } else if (this.cmbPushBranchRepository.getSelectionIndex() == -1) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_BRANCH_PREFIX_REPOSITORY);
            } else if (Strings.isNullOrEmpty((String)this.txtPushBranchPrefix.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_BRANCH_PREFIX);
            } else if (pushBranchPrefixValid != null) {
                this.setErrorMessage(pushBranchPrefixValid);
            }
            this.setPageComplete(this.getErrorMessage() == null);
        }

        private boolean isUriAlreadyAdded(String newText) {
            String mangledNewText = Urls.mangle((String)newText);
            for (ISnippetRepository repository : GitBasedRepositoryConfigurationWizard.this.repositories.getRepositories()) {
                String fetchUrl = repository.getRepositoryLocation();
                if (!Urls.mangle((String)fetchUrl).equals(mangledNewText)) continue;
                return true;
            }
            return false;
        }

        public boolean canFinish() {
            return this.isPageComplete();
        }
    }
}

