/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.ContextLoadingProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.RepositoryProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.SnippetProposal;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.snipmatch.ISearchContext;
import org.eclipse.recommenders.snipmatch.ISnippet;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.SearchContext;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public abstract class AbstractContentAssistProcessor<T extends ContentAssistInvocationContext>
implements IContentAssistProcessor {
    private final Repositories repos;
    private final SnippetRepositoryConfigurations configs;
    private final IProjectCoordinateProvider pcProvider;
    protected final IDependencyListener dependencyListener;
    private final Image contextLoadingImage;
    private final Image snippetImage;
    protected final TemplateContextType templateContextType;
    protected T context;
    protected Set<DependencyInfo> availableDependencies;
    private String terms;
    private ContextLoadingProposal contextLoadingProposal;
    private String filename;

    @Inject
    public AbstractContentAssistProcessor(TemplateContextType templateContextType, SnippetRepositoryConfigurations configs, Repositories repos, IProjectCoordinateProvider pcProvider, IDependencyListener dependencyListener, SharedImages images) {
        this.templateContextType = templateContextType;
        this.repos = repos;
        this.configs = configs;
        this.dependencyListener = dependencyListener;
        this.pcProvider = pcProvider;
        this.contextLoadingImage = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_HOURGLASS);
        this.snippetImage = images.getImage((SharedImages.ImageResource)SharedImages.Images.OBJ_BULLET_BLUE);
    }

    public void setContext(T context) {
        this.context = context;
        this.availableDependencies = this.calculateAvailableDependencies(context);
        if (!AbstractContentAssistProcessor.allProjectCoordinatesCached(this.pcProvider, this.availableDependencies)) {
            this.contextLoadingProposal = new ContextLoadingProposal(this.pcProvider, this.availableDependencies, this.contextLoadingImage);
            this.contextLoadingProposal.schedule();
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    protected abstract Set<DependencyInfo> calculateAvailableDependencies(T var1);

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (StringUtils.isEmpty((CharSequence)this.terms)) {
            return new ICompletionProposal[0];
        }
        Set<ProjectCoordinate> projectCoordinates = AbstractContentAssistProcessor.tryResolve(this.pcProvider, this.availableDependencies);
        SearchContext searchContext = new SearchContext(this.terms, this.getLocation(), this.filename, projectCoordinates);
        LinkedList proposals = Lists.newLinkedList();
        ArrayList sortedConfigs = Lists.newArrayList();
        sortedConfigs.addAll(this.configs.getRepos());
        Collections.sort(sortedConfigs, new Comparator<SnippetRepositoryConfiguration>(){

            @Override
            public int compare(SnippetRepositoryConfiguration o1, SnippetRepositoryConfiguration o2) {
                return Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        Point selection = viewer.getSelectedRange();
        Region region = new Region(selection.x, selection.y);
        Position position = new Position(selection.x, selection.y);
        IDocument document = viewer.getDocument();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        TemplateContext templateContext = this.getTemplateContext(document, position);
        templateContext.setVariable("selection", selectedText);
        int repositoryPriority = 0;
        while (repositoryPriority < sortedConfigs.size()) {
            List recommendations;
            Optional<ISnippetRepository> repo = this.repos.getRepository(((SnippetRepositoryConfiguration)sortedConfigs.get(repositoryPriority)).getId());
            if (repo.isPresent() && !(recommendations = ((ISnippetRepository)repo.get()).search((ISearchContext)searchContext)).isEmpty()) {
                proposals.add(new RepositoryProposal((SnippetRepositoryConfiguration)sortedConfigs.get(repositoryPriority), repositoryPriority, recommendations.size()));
                for (Recommendation recommendation : recommendations) {
                    ISnippet snippet = (ISnippet)recommendation.getProposal();
                    Template template = new Template(snippet.getName(), snippet.getDescription(), "Snipmatch-Java-Context", snippet.getCode(), true);
                    try {
                        proposals.add(SnippetProposal.newSnippetProposal((Recommendation<ISnippet>)recommendation, repositoryPriority, template, templateContext, (IRegion)region, this.snippetImage));
                    }
                    catch (Exception e) {
                        Logs.log((Logs.ILogMessage)LogMessages.ERROR_CREATING_SNIPPET_PROPOSAL_FAILED, (Throwable)e);
                    }
                }
            }
            ++repositoryPriority;
        }
        if (this.isResolvingProjectDependencies()) {
            proposals.add(this.contextLoadingProposal);
        }
        return (ICompletionProposal[])Iterables.toArray((Iterable)proposals, ICompletionProposal.class);
    }

    protected abstract Location getLocation();

    protected abstract TemplateContext getTemplateContext(IDocument var1, Position var2);

    private boolean isResolvingProjectDependencies() {
        return this.contextLoadingProposal != null && this.contextLoadingProposal.isStillLoading();
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    private static boolean allProjectCoordinatesCached(IProjectCoordinateProvider pcProvider, Set<DependencyInfo> dependencyInfos) {
        for (DependencyInfo dependencyInfo : dependencyInfos) {
            Result pc = pcProvider.tryResolve(dependencyInfo);
            if (pc.getReason() != 1) continue;
            return false;
        }
        return true;
    }

    private static Set<ProjectCoordinate> tryResolve(IProjectCoordinateProvider pcProvider, Set<DependencyInfo> dependencyInfos) {
        HashSet result = Sets.newHashSet();
        for (DependencyInfo dependencyInfo : dependencyInfos) {
            ProjectCoordinate pc = (ProjectCoordinate)pcProvider.tryResolve(dependencyInfo).or(null);
            if (pc == null) continue;
            result.add(pc);
        }
        return result;
    }
}

