/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp.completion;

import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.template.java.JavaContext;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.rcp.DependencyInfos;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.AbstractContentAssistProcessor;
import org.eclipse.recommenders.internal.snipmatch.rcp.completion.JavaTemplateContextType;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.snipmatch.Location;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Logs;

public class JavaContentAssistProcessor
extends AbstractContentAssistProcessor<JavaContentAssistInvocationContext> {
    @Inject
    public JavaContentAssistProcessor(SnippetRepositoryConfigurations configs, Repositories repos, IProjectCoordinateProvider pcProvider, IDependencyListener dependencyListener, SharedImages images) {
        super(JavaTemplateContextType.getInstance(), configs, repos, pcProvider, dependencyListener, images);
    }

    @Override
    protected Set<DependencyInfo> calculateAvailableDependencies(JavaContentAssistInvocationContext context) {
        IJavaProject project = context.getProject();
        return this.dependencyListener.getDependenciesForProject(DependencyInfos.createDependencyInfoForProject((IJavaProject)project));
    }

    @Override
    protected TemplateContext getTemplateContext(IDocument document, Position position) {
        ICompilationUnit cu = ((JavaContentAssistInvocationContext)this.context).getCompilationUnit();
        JavaContext javaTemplateContext = new JavaContext(this.templateContextType, document, position, cu);
        javaTemplateContext.setForceEvaluation(true);
        return javaTemplateContext;
    }

    @Override
    protected Location getLocation() {
        try {
            String partition = TextUtilities.getContentType((IDocument)((JavaContentAssistInvocationContext)this.context).getDocument(), (String)"___java_partitioning", (int)((JavaContentAssistInvocationContext)this.context).getInvocationOffset(), (boolean)true);
            return JavaContentAssistProcessor.getLocation(this.context, partition);
        }
        catch (BadLocationException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_COMPUTE_LOCATION, (Throwable)e);
            return Location.JAVA_FILE;
        }
    }

    @VisibleForTesting
    static Location getLocation(ContentAssistInvocationContext context, String partition) {
        if (partition.equals("__java_javadoc")) {
            return Location.JAVADOC;
        }
        if (partition.equals("__java_singleline_comment") || partition.equals("__java_multiline_comment")) {
            return Location.JAVA_FILE;
        }
        JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
        CompletionContext coreContext = javaContext.getCoreContext();
        if (coreContext == null) {
            return Location.JAVA_FILE;
        }
        if (coreContext.isInJavadoc()) {
            return Location.JAVADOC;
        }
        int tokenLocation = coreContext.getTokenLocation();
        if ((tokenLocation & 1) != 0) {
            return Location.JAVA_TYPE_MEMBERS;
        }
        if ((tokenLocation & 2) != 0) {
            return Location.JAVA_STATEMENTS;
        }
        return Location.JAVA_FILE;
    }
}

