/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.news.impl.poll;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.mylyn.commons.notifications.core.NotificationEnvironment;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedEntry;
import org.eclipse.mylyn.internal.commons.notifications.feed.FeedReader;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.impl.poll.IFeedItemStore;

public class DefaultFeedItemStore
implements IFeedItemStore {
    private final Map<URI, List<NewsItem>> cache = new ConcurrentHashMap<URI, List<NewsItem>>();
    private final NotificationEnvironment environment = new NotificationEnvironment();

    @Override
    public List<NewsItem> udpate(URI feedUri, InputStream stream, @Nullable IProgressMonitor monitor) throws IOException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        try {
            List<NewsItem> updatedItems = this.parseNewsItems(stream, feedUri.toString(), progress.newChild(1));
            List<NewsItem> oldItems = updatedItems.isEmpty() ? this.cache.remove(feedUri) : this.cache.put(feedUri, updatedItems);
            Set<String> oldIds = this.getIds(oldItems);
            ArrayList<NewsItem> newItems = new ArrayList<NewsItem>();
            for (NewsItem updatedItem : updatedItems) {
                if (oldIds.contains(updatedItem.getId())) continue;
                newItems.add(updatedItem);
            }
            ArrayList<NewsItem> arrayList = newItems;
            return arrayList;
        }
        finally {
            stream.close();
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    @Override
    public List<NewsItem> getNewsItems(URI feedUri) {
        List<NewsItem> cachedItems = this.cache.get(feedUri);
        return cachedItems != null ? cachedItems : Collections.emptyList();
    }

    private List<NewsItem> parseNewsItems(InputStream in, String eventId, SubMonitor monitor) throws IOException {
        FeedReader reader = new FeedReader(eventId, this.environment);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IStatus status = reader.parse(in, (IProgressMonitor)progress.newChild(80));
        if (status.isOK()) {
            return this.convertEntries(reader.getEntries(), progress.newChild(20));
        }
        progress.setWorkRemaining(0);
        Throwable exception = status.getException();
        if (exception instanceof Exception) {
            throw new IOException((Exception)exception);
        }
        return Collections.emptyList();
    }

    private List<NewsItem> convertEntries(List<FeedEntry> entries, SubMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)entries.size());
        ArrayList<NewsItem> items = new ArrayList<NewsItem>(entries.size());
        for (FeedEntry entry : entries) {
            try {
                try {
                    URI uri = new URI(entry.getUrl());
                    NewsItem item = new NewsItem(entry.getTitle(), entry.getDate(), uri, entry.getId());
                    items.add(item);
                }
                catch (URISyntaxException uRISyntaxException) {
                    progress.worked(1);
                    continue;
                }
            }
            catch (Throwable throwable) {
                progress.worked(1);
                throw throwable;
            }
            progress.worked(1);
        }
        return items;
    }

    private Set<String> getIds(@Nullable List<NewsItem> items) {
        if (items == null) {
            return Collections.emptySet();
        }
        HashSet<String> ids = new HashSet<String>();
        for (NewsItem item : items) {
            ids.add(item.getId());
        }
        return ids;
    }
}

