/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.commons.bayesnet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.recommenders.commons.bayesnet.BayesianNetwork;
import org.eclipse.recommenders.commons.bayesnet.Node;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.io.IBayesNetWriter;

public class CommonsWriter
implements IBayesNetWriter {
    private OutputStream out;

    public CommonsWriter(OutputStream out) {
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void write(BayesNet bayesNet) throws IOException {
        try {
            BayesianNetwork.write(this.toBayesianNetwork(bayesNet), this.out);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private BayesianNetwork toBayesianNetwork(BayesNet bayesNet) {
        Node n;
        BayesianNetwork network = new BayesianNetwork();
        for (BayesNode node : bayesNet.getNodes()) {
            n = new Node(node.getName());
            n.setStates(node.getOutcomes().toArray(new String[node.getOutcomeCount()]));
            network.addNode(n);
        }
        for (BayesNode node : bayesNet.getNodes()) {
            n = network.getNode(node.getName());
            ArrayList<Node> parents = new ArrayList<Node>();
            for (BayesNode parent : node.getParents()) {
                parents.add(network.getNode(parent.getName()));
            }
            n.setParents(parents.toArray(new Node[parents.size()]));
            n.setProbabilities(node.getProbabilities());
        }
        return network;
    }
}

