/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.examples.models;

import java.io.File;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.examples.models.EclipseProjectCoordinateProvider;
import org.eclipse.recommenders.examples.models.UsingModelProvider;
import org.eclipse.recommenders.models.IModelProvider;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class CompletionEngineExample {
    void resolveGavFromPackgeFragmentRoot(IPackageFragementRoot jdtElement, EclipseProjectCoordinateProvider r) {
        if (!jdtElement.isjar()) {
            jdtElement.isSourceFolder();
        }
        r.map(jdtElement);
    }

    void resolveGavFromIJavaElement(IJavaElement jdtElement, EclipseProjectCoordinateProvider r) {
        r.map(jdtElement);
    }

    void resolveGavFromSourceFolder(IPackageFragementRoot srcFolder, EclipseProjectCoordinateProvider r) {
    }

    private static final class CompletionEngine {
        IModelProvider<IUniqueName<ITypeName>, UsingModelProvider.RecommendationModel> modelProvider;
        EclipseProjectCoordinateProvider coordService;

        private CompletionEngine() {
        }

        void computeProposals(IJavaElement e) {
            ProjectCoordinate pc = (ProjectCoordinate)this.coordService.map(e).orNull();
            ITypeName type = e.getITypeName();
            IUniqueName<ITypeName> name = this.createQualifiedName(pc, type);
            UsingModelProvider.RecommendationModel net = (UsingModelProvider.RecommendationModel)this.modelProvider.acquireModel(name).orNull();
            this.modelProvider.releaseModel(net);
        }

        private IUniqueName<ITypeName> createQualifiedName(ProjectCoordinate pc, ITypeName name) {
            return null;
        }
    }

    static interface IJavaElement {
        public ITypeName getITypeName();
    }

    static interface IJavaProject {
    }

    static interface IPackageFragementRoot
    extends IJavaElement {
        public File getFile();

        public boolean isjar();

        public boolean isSourceFolder();
    }
}

