/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.notifications;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.mylyn.commons.notifications.ui.NotificationsUi;
import org.eclipse.recommenders.internal.news.rcp.FeedDescriptor;
import org.eclipse.recommenders.internal.news.rcp.NewsRcpPreferences;
import org.eclipse.recommenders.internal.news.rcp.PollingResults;
import org.eclipse.recommenders.internal.news.rcp.notifications.NewNewsItemsNotification;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.poll.PollingResult;

@Creatable
@Singleton
public class NotificationBridge {
    private final int MAX_NOTIFICATIONS = 4;
    private final NewsRcpPreferences preferences;
    private final ECommandService commandService;
    private final EHandlerService handlerService;

    @Inject
    public NotificationBridge(NewsRcpPreferences preferences, ECommandService commandService, EHandlerService handlerService) {
        this.preferences = preferences;
        this.commandService = commandService;
        this.handlerService = handlerService;
    }

    @Inject
    @Optional
    public void handlePollingResults(@EventTopic(value="org_eclipse_recommenders_news/pollingResults") Collection<PollingResult> pollingResults) {
        ArrayList<NewNewsItemsNotification> notifications = new ArrayList<NewNewsItemsNotification>();
        List<FeedDescriptor> feedDescriptors = this.preferences.getFeedDescriptors();
        Object token = new Object();
        block0: for (PollingResult pollingResult : pollingResults) {
            for (FeedDescriptor feedDescriptor : feedDescriptors) {
                if (!feedDescriptor.isEnabled() || !pollingResult.getFeedUri().equals(feedDescriptor.getUri())) continue;
                for (NewsItem newNewsItem : PollingResults.getNewNewsItems(pollingResult, 20)) {
                    notifications.add(new NewNewsItemsNotification(newNewsItem, feedDescriptor, token, this.commandService, this.handlerService));
                }
                continue block0;
            }
        }
        NotificationsUi.getService().notify(Ordering.natural().leastOf(notifications, 4));
    }
}

