/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.calls;

import com.google.common.annotations.Beta;
import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.calls.ICallModel;
import org.eclipse.recommenders.calls.ICallModelProvider;
import org.eclipse.recommenders.calls.JayesCallModel;
import org.eclipse.recommenders.calls.NullCallModel;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class SingleZipCallModelProvider
implements ICallModelProvider,
Openable {
    private static final Logger LOG = LoggerFactory.getLogger(SingleZipCallModelProvider.class);
    private static final int CACHE_SIZE = 30;
    private final LoadingCache<ITypeName, ICallModel> cache = CacheBuilder.newBuilder().expireAfterAccess(3L, TimeUnit.MINUTES).maximumSize(30L).build((CacheLoader)new CallNetCacheLoader());
    private final File models;
    private final Map<String, IInputStreamTransformer> transformers;
    private ZipFile zip;

    public SingleZipCallModelProvider(File models, Map<String, IInputStreamTransformer> transformers) {
        this.models = models;
        this.transformers = transformers;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Optional<ICallModel> acquireModel(UniqueTypeName key) {
        try {
            ICallModel net = (ICallModel)this.cache.get((Object)((ITypeName)key.getName()));
            net.reset();
            return Optional.of((Object)net);
        }
        catch (ExecutionException e) {
            LOG.error("Failed to acquire model for " + key, (Throwable)e);
            return Optional.absent();
        }
    }

    public Set<ITypeName> acquireableTypes() {
        Set acquireableTypesSet = Zips.types(this.zip.entries(), (String)".jbif");
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            acquireableTypesSet.addAll(Zips.types(this.zip.entries(), (String)(".jbif." + transformer.getKey())));
        }
        return acquireableTypesSet;
    }

    public void releaseModel(ICallModel value) {
    }

    private final class CallNetCacheLoader
    extends CacheLoader<ITypeName, ICallModel> {
        private CallNetCacheLoader() {
        }

        public ICallModel load(ITypeName type) throws IOException {
            ICallModel model;
            InputStream in;
            block4: {
                NullCallModel nullCallModel;
                in = null;
                try {
                    String path = Zips.path((ITypeName)type, (String)".jbif");
                    in = (InputStream)this.getInputStream(SingleZipCallModelProvider.this.zip, path).orNull();
                    model = null;
                    if (in != null) {
                        model = JayesCallModel.load(in, type);
                    }
                    if (model != null) break block4;
                    nullCallModel = NullCallModel.INSTANCE;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)in);
                return nullCallModel;
            }
            ICallModel iCallModel = model;
            IOUtils.closeQuietly((Closeable)in);
            return iCallModel;
        }

        private Optional<InputStream> getInputStream(ZipFile zip, String path) throws IOException {
            for (Map.Entry transformer : SingleZipCallModelProvider.this.transformers.entrySet()) {
                ZipEntry toTransform = zip.getEntry(String.valueOf(path) + "." + (String)transformer.getKey());
                if (toTransform == null) continue;
                return Optional.of((Object)((IInputStreamTransformer)transformer.getValue()).transform(zip.getInputStream(toTransform)));
            }
            ZipEntry entry = zip.getEntry(path);
            if (entry == null) {
                return Optional.absent();
            }
            return Optional.of((Object)zip.getInputStream(entry));
        }
    }
}

