/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.jdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class ContentAssistEnablementBlock {
    public static final String JDT_ALL_CATEGORY = "org.eclipse.jdt.ui.javaAllProposalCategory";
    public static final String MYLYN_ALL_CATEGORY = "org.eclipse.mylyn.java.ui.javaAllProposalCategory";
    protected final String categoryId;
    protected final Button enablement;

    public ContentAssistEnablementBlock(Composite parent, String label, final String categoryId) {
        this.categoryId = categoryId;
        this.enablement = new Button(parent, 32);
        this.enablement.setText(label);
        this.enablement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HashSet cats = Sets.newHashSet((Object[])PreferenceConstants.getExcludedCompletionProposalCategories());
                if (ContentAssistEnablementBlock.this.enablement.getSelection()) {
                    cats.remove(categoryId);
                } else {
                    cats.add(categoryId);
                }
                ContentAssistEnablementBlock.this.additionalExcludedCompletionCategoriesUpdates(ContentAssistEnablementBlock.this.enablement.getSelection(), cats);
                PreferenceConstants.setExcludedCompletionProposalCategories((String[])cats.toArray(new String[cats.size()]));
            }
        });
    }

    protected void additionalExcludedCompletionCategoriesUpdates(boolean isEnabled, Set<String> cats) {
    }

    public void loadSelection() {
        Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
        boolean isFeatureEnabled = !ArrayUtils.contains((Object[])excluded, (Object)this.categoryId);
        this.enablement.setSelection(isFeatureEnabled);
    }

    public static boolean isMylynInstalled() {
        CompletionProposalComputerRegistry reg = CompletionProposalComputerRegistry.getDefault();
        for (CompletionProposalCategory cat : reg.getProposalCategories()) {
            if (!cat.getId().equals(MYLYN_ALL_CATEGORY)) continue;
            return true;
        }
        return false;
    }
}

