/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnippetRepositoryConfigurations;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public final class SelectRepositoryDialog {
    public static Optional<ISnippetRepository> openSelectRepositoryDialog(Shell shell, Repositories repos, SnippetRepositoryConfigurations configs) {
        return SelectRepositoryDialog.openSelectRepositoryDialog(shell, repos, configs, null);
    }

    public static Optional<ISnippetRepository> openSelectRepositoryDialog(Shell shell, Repositories repos, SnippetRepositoryConfigurations configs, SnippetRepositoryConfiguration preSelectedConfiguration) {
        List<SnippetRepositoryConfiguration> filteredConfigurations = SelectRepositoryDialog.filterImportSupportingConfigurations(repos, configs);
        if (filteredConfigurations.isEmpty()) {
            return Optional.absent();
        }
        ListDialog selectRepositoryDialog = SelectRepositoryDialog.createSelectRepositoryDialog(shell, filteredConfigurations, preSelectedConfiguration, repos);
        int status = selectRepositoryDialog.open();
        if (status == 0) {
            SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)Checks.cast((Object)selectRepositoryDialog.getResult()[0]);
            return repos.getRepository(config.getId());
        }
        return Optional.absent();
    }

    private static ListDialog createSelectRepositoryDialog(Shell shell, List<SnippetRepositoryConfiguration> configurations, SnippetRepositoryConfiguration preSelectedConfiguration, Repositories repos) {
        ListDialog selectRepositoryDialog = new ListDialog(shell);
        selectRepositoryDialog.setTitle(Messages.SELECT_REPOSITORY_DIALOG_TITLE);
        selectRepositoryDialog.setMessage(Messages.SELECT_REPOSITORY_DIALOG_MESSAGE);
        selectRepositoryDialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
        selectRepositoryDialog.setInput(configurations);
        SnippetRepositoryConfiguration selectedElement = null;
        if (preSelectedConfiguration != null && SelectRepositoryDialog.isImportSupported(preSelectedConfiguration, repos)) {
            selectedElement = preSelectedConfiguration;
        } else if (!configurations.isEmpty()) {
            selectedElement = configurations.get(0);
        }
        if (selectedElement != null) {
            selectRepositoryDialog.setInitialSelections((Object[])new SnippetRepositoryConfiguration[]{selectedElement});
        }
        selectRepositoryDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                SnippetRepositoryConfiguration config = (SnippetRepositoryConfiguration)Checks.cast((Object)element);
                return config.getName();
            }
        });
        return selectRepositoryDialog;
    }

    private static boolean isImportSupported(SnippetRepositoryConfiguration configuration, Repositories repos) {
        ISnippetRepository repo = (ISnippetRepository)repos.getRepository(configuration.getId()).orNull();
        return repo != null && repo.isImportSupported();
    }

    private static List<SnippetRepositoryConfiguration> filterImportSupportingConfigurations(Repositories repos, SnippetRepositoryConfigurations configs) {
        ArrayList<SnippetRepositoryConfiguration> filteredConfigurations = new ArrayList<SnippetRepositoryConfiguration>();
        for (SnippetRepositoryConfiguration config : configs.getRepos()) {
            if (!SelectRepositoryDialog.isImportSupported(config, repos)) continue;
            filteredConfigurations.add(config);
        }
        return filteredConfigurations;
    }
}

