/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models.rcp.actions;

import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.internal.models.rcp.EclipseModelRepository;
import org.eclipse.recommenders.models.IModelIndex;
import org.eclipse.recommenders.models.ModelCoordinate;
import org.eclipse.recommenders.models.rcp.actions.TriggerModelDownloadForModelCoordinatesAction;

public class TriggerModelDownloadForProjectCoordinatesAction
extends TriggerModelDownloadForModelCoordinatesAction {
    private final List<String> modelTypes;
    private IModelIndex modelIndex;
    private Set<ProjectCoordinate> pcs = Sets.newHashSet();

    TriggerModelDownloadForProjectCoordinatesAction(String text, List<String> modelClassifier, IModelIndex modelIndex, EclipseModelRepository repo, EventBus bus) {
        super(text, repo, bus);
        this.modelTypes = modelClassifier;
        this.modelIndex = modelIndex;
    }

    TriggerModelDownloadForProjectCoordinatesAction(String text, Set<ProjectCoordinate> pcs, List<String> modelClassifier, IModelIndex modelIndex, EclipseModelRepository repo, EventBus bus) {
        this(text, modelClassifier, modelIndex, repo, bus);
        this.pcs = pcs;
    }

    @Override
    public void run() {
        this.triggerDownloadForProjectCoordinates(this.pcs);
    }

    public void triggerDownloadForProjectCoordinates(Set<ProjectCoordinate> pcs) {
        HashSet mcs = Sets.newHashSet();
        for (ProjectCoordinate pc : pcs) {
            for (String modelType : this.modelTypes) {
                ModelCoordinate mc = (ModelCoordinate)this.modelIndex.suggest(pc, modelType).orNull();
                if (mc == null) continue;
                mcs.add(mc);
            }
        }
        this.triggerDownloadForModelCoordinates(mcs);
    }
}

