/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class Uris {
    private Uris() {
    }

    public static String toStringWithMaskedPassword(URI uri, char mask) {
        int indexOfColon;
        if (uri.isOpaque()) {
            return uri.toString();
        }
        String userInfo = uri.getUserInfo();
        if (userInfo != null && (indexOfColon = userInfo.indexOf(58)) > 0) {
            userInfo = String.valueOf(userInfo.substring(0, indexOfColon + 1)) + StringUtils.repeat((char)mask, (int)(userInfo.length() - indexOfColon - 1));
        }
        return Uris.toStringWithUserInfo(uri, userInfo);
    }

    public static String toStringWithoutUserinfo(URI uri) {
        if (uri.isOpaque()) {
            return uri.toString();
        }
        return Uris.toStringWithUserInfo(uri, null);
    }

    private static String toStringWithUserInfo(URI uri, String userInfo) {
        try {
            return new URI(uri.getScheme(), userInfo, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Optional<URI> parseURI(String uriString) {
        try {
            return Optional.of((Object)new URI(uriString));
        }
        catch (URISyntaxException uRISyntaxException) {
            return Optional.absent();
        }
    }

    public static URI toUri(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean isUriProtocolSupported(URI uri, List<String> protocols) {
        for (String protocol : protocols) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)protocol, (CharSequence)uri.getScheme())) continue;
            return true;
        }
        return false;
    }
}

