/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.rcp.completion.rules;

import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.RecommendersCompletionContext;
import org.eclipse.recommenders.internal.rcp.CachingAstProvider;
import org.eclipse.recommenders.rcp.IAstProvider;
import org.eclipse.recommenders.testing.rcp.completion.rules.TemporaryProject;
import org.eclipse.recommenders.testing.rcp.jdt.JavaContentAssistContextMock;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Pair;
import org.junit.Assert;

public class TemporaryFile {
    private static final String JAVA_IDENTIFIER_REGEX = "([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*)";
    private final ICompilationUnit cu;
    private final Set<Integer> markers;
    private final TemporaryProject tempProject;

    TemporaryFile(TemporaryProject parentProject, CharSequence code) throws CoreException {
        this.tempProject = parentProject;
        Pair<ICompilationUnit, Set<Integer>> struct = this.createFileAndParseWithMarkers(code);
        this.cu = (ICompilationUnit)struct.getFirst();
        this.markers = (Set)struct.getSecond();
    }

    public CompilationUnit getAst() {
        return SharedASTProvider.getAST((ITypeRoot)this.cu, (SharedASTProvider.WAIT_FLAG)SharedASTProvider.WAIT_YES, null);
    }

    public IRecommendersCompletionContext triggerContentAssist() throws JavaModelException {
        JavaContentAssistContextMock javaContext = new JavaContentAssistContextMock(this.cu, this.markers.iterator().next());
        return new RecommendersCompletionContext((JavaContentAssistInvocationContext)javaContext, (IAstProvider)new CachingAstProvider());
    }

    private Pair<ICompilationUnit, Set<Integer>> createFileAndParseWithMarkers(CharSequence contentWithMarkers) throws CoreException {
        Pair<String, Set<Integer>> content = this.findMarkers(contentWithMarkers, "$");
        ICompilationUnit cu = this.createFile((String)content.getFirst());
        this.tempProject.refreshAndBuildProject();
        return Pair.newPair((Object)cu, (Object)((Set)content.getSecond()));
    }

    private Pair<String, Set<Integer>> findMarkers(CharSequence content, String marker) {
        TreeSet markers = Sets.newTreeSet();
        int pos = 0;
        StringBuilder sb = new StringBuilder(content);
        while ((pos = sb.indexOf(marker, pos)) != -1) {
            sb.deleteCharAt(pos);
            markers.add(pos);
            Checks.ensureIsTrue((pos <= sb.length() ? 1 : 0) != 0);
            --pos;
        }
        return Pair.newPair((Object)sb.toString(), (Object)markers);
    }

    private ICompilationUnit createFile(String content) throws CoreException {
        String fileName = String.valueOf(TemporaryFile.findClassName(content)) + ".java";
        StringBuilder projectRelativeFilePath = new StringBuilder();
        projectRelativeFilePath.append("src");
        projectRelativeFilePath.append(File.separator);
        projectRelativeFilePath.append(fileName);
        Path projectRelativePath = new Path(projectRelativeFilePath.toString());
        IFile file = this.tempProject.getProject().getFile((IPath)projectRelativePath);
        if (file.exists()) {
            file.delete(true, null);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        file.create((InputStream)is, true, null);
        int attempts = 0;
        while (!file.exists()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (++attempts <= 10) continue;
            throw new IllegalStateException("Failed to create file");
        }
        IJavaProject javaProject = this.tempProject.getJavaProject();
        if (javaProject == null) {
            throw new IllegalStateException("The temporaryProject does not yet have an associated IJavaProject.");
        }
        Path srcRelativePath = new Path(fileName);
        ICompilationUnit cu = (ICompilationUnit)javaProject.findElement((IPath)srcRelativePath);
        while (cu == null) {
            cu = (ICompilationUnit)javaProject.findElement((IPath)srcRelativePath);
        }
        return cu;
    }

    public void openFileInEditor() throws CoreException {
        JavaUI.openInEditor((IJavaElement)this.cu);
    }

    private static String findClassName(CharSequence source) {
        Pattern p = Pattern.compile(".*?class\\s+([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*).*", 32);
        Matcher matcher = p.matcher(source);
        if (!matcher.matches()) {
            p = Pattern.compile(".*interface\\s+([a-zA-Z_$\\p{Lu}\\p{Ll}]{1}[a-zA-Z_$0-9\\p{Lu}\\p{Ll}\\p{Nl}]*).*", 32);
            matcher = p.matcher(source);
        }
        Assert.assertTrue((boolean)matcher.matches());
        return matcher.group(1);
    }
}

