/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.coordinates.jre;

import com.google.common.base.Optional;
import java.io.File;
import org.eclipse.recommenders.coordinates.AbstractProjectCoordinateAdvisor;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.utils.Versions;

public class JREDirectoryNameAdvisor
extends AbstractProjectCoordinateAdvisor {
    @Override
    protected Optional<ProjectCoordinate> doSuggest(DependencyInfo dependencyInfo) {
        File directory = dependencyInfo.getFile();
        do {
            String version;
            if (!Versions.isValidVersion((String)(version = Versions.canonicalizeVersion((String)directory.getName())))) continue;
            return Optional.of((Object)new ProjectCoordinate("jre", "jre", version));
        } while ((directory = directory.getParentFile()) != null);
        return Optional.absent();
    }

    @Override
    public boolean isApplicable(DependencyType dependencyType) {
        return dependencyType == DependencyType.JRE;
    }
}

