/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp.read;

import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;
import org.eclipse.recommenders.news.api.NewsItem;
import org.eclipse.recommenders.news.api.read.IReadItemsStore;

public class ReadNewsItemsHandler {
    private final IReadItemsStore readItemsStore;
    private final ECommandService commandService;
    private final EHandlerService handlerService;
    private final UISynchronize uiSynchronize;
    private final IEventBroker eventBroker;

    @Inject
    public ReadNewsItemsHandler(IReadItemsStore readItemsStore, ECommandService commandService, EHandlerService handlerService, UISynchronize uiSynchronize, IEventBroker eventBroker) {
        this.readItemsStore = readItemsStore;
        this.commandService = commandService;
        this.handlerService = handlerService;
        this.uiSynchronize = uiSynchronize;
        this.eventBroker = eventBroker;
    }

    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.recommenders.news.rcp.commandParameter.newsItems") List<NewsItem> newsItems) {
        return !newsItems.isEmpty();
    }

    @Execute
    public void execute(final @Named(value="org.eclipse.recommenders.news.rcp.commandParameter.newsItems") Collection<NewsItem> newsItems, final @Optional @Named(value="org.eclipse.recommenders.news.rcp.commandParameter.openBrowser") @Nullable Boolean openBrowser) {
        new Job(Messages.JOB_NAME_READ_NEWS_ITEMS){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)newsItems.size());
                for (NewsItem newsItem : newsItems) {
                    this.readNewsItem(newsItem, progress.newChild(1));
                }
                ReadNewsItemsHandler.this.eventBroker.post("org_eclipse_recommenders_news/newsItemsRead", (Object)newsItems);
                return Status.OK_STATUS;
            }

            private void readNewsItem(NewsItem newsItem, SubMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                if (Boolean.TRUE.equals(openBrowser)) {
                    this.openBrowser(newsItem);
                }
                progress.setWorkRemaining(1);
                ReadNewsItemsHandler.this.readItemsStore.markAsRead(newsItem);
                progress.worked(1);
            }

            private void openBrowser(final NewsItem newsItem) {
                ReadNewsItemsHandler.this.uiSynchronize.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ParameterizedCommand command = ReadNewsItemsHandler.this.commandService.createCommand("org.eclipse.ui.browser.openBrowser", (Map)ImmutableMap.of((Object)"url", (Object)newsItem.getUri().toString()));
                        ReadNewsItemsHandler.this.handlerService.executeHandler(command);
                    }
                });
            }
        }.schedule();
    }
}

