/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.coordinates.rcp;

import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.IDependencyListener;
import org.eclipse.recommenders.coordinates.rcp.DependencyInfos;
import org.eclipse.recommenders.internal.coordinates.rcp.l10n.LogMessages;
import org.eclipse.recommenders.jdt.JavaElementsFinder;
import org.eclipse.recommenders.rcp.JavaModelEvents;
import org.eclipse.recommenders.utils.Logs;

public class EclipseDependencyListener
implements IDependencyListener {
    private final Multimap<IJavaProject, DependencyInfo> workspaceDependenciesByProject = HashMultimap.create();
    private final Multimap<IJavaProject, IPackageFragmentRoot> jrePackageFragmentRoots = HashMultimap.create();
    private final BiMap<IJavaProject, DependencyInfo> projectDependencyInfoCache = HashBiMap.create();

    public EclipseDependencyListener(EventBus bus) {
        bus.register((Object)this);
        this.parseWorkspaceForDependencies();
    }

    private void parseWorkspaceForDependencies() {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                IJavaProject javaProject;
                if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && (javaProject = JavaCore.create((IProject)project)) != null) {
                    this.registerDependenciesForJavaProject(javaProject);
                }
            }
            catch (CoreException e) {
                Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_REGISTER_PROJECT_DEPENDENCIES, (Throwable)e, (Object[])new Object[]{project});
            }
            ++n2;
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectOpened e) {
        this.registerDependenciesForJavaProject(e.project);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectClosed e) {
        this.deregisterDependenciesForJavaProject(e.project);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JarPackageFragmentRootAdded e) {
        this.registerDependencyForJAR(e.root);
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JarPackageFragmentRootRemoved e) {
        this.deregisterDependencyForJAR(e.root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDependenciesForJavaProject(IJavaProject javaProject) {
        DependencyInfo jreDependencyInfo = (DependencyInfo)DependencyInfos.createJreDependencyInfo(javaProject).orNull();
        EclipseDependencyListener eclipseDependencyListener = this;
        synchronized (eclipseDependencyListener) {
            if (jreDependencyInfo != null) {
                this.workspaceDependenciesByProject.put((Object)javaProject, (Object)jreDependencyInfo);
                this.jrePackageFragmentRoots.putAll((Object)javaProject, EclipseDependencyListener.detectJREPackageFragementRoots(javaProject));
            }
            this.workspaceDependenciesByProject.putAll((Object)javaProject, this.searchForAllDependenciesOfProject(javaProject));
            this.cacheProjectDependencyInfo(javaProject);
        }
    }

    private synchronized Set<DependencyInfo> searchForAllDependenciesOfProject(IJavaProject javaProject) {
        HashSet<DependencyInfo> dependencies = new HashSet<DependencyInfo>();
        Collection jreRoots = this.jrePackageFragmentRoots.get((Object)javaProject);
        IPackageFragmentRoot[] iPackageFragmentRootArray = JavaElementsFinder.getAllPackageFragmentRoots((IJavaProject)javaProject);
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            DependencyInfo dependencyInfo;
            IJavaProject project;
            IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n2];
            if (!jreRoots.contains(packageFragmentRoot) && packageFragmentRoot instanceof JarPackageFragmentRoot) {
                DependencyInfo dependencyInfo2 = (DependencyInfo)DependencyInfos.createJarDependencyInfo(packageFragmentRoot).orNull();
                if (dependencyInfo2 != null) {
                    dependencies.add(dependencyInfo2);
                }
            } else if (JavaElementsFinder.getPackageFragmentRootKind((IPackageFragmentRoot)packageFragmentRoot) == 1 && packageFragmentRoot.getJavaProject() != null && (project = packageFragmentRoot.getJavaProject()) != null && (dependencyInfo = (DependencyInfo)DependencyInfos.createProjectDependencyInfo(project).orNull()) != null) {
                dependencies.add(dependencyInfo);
            }
            ++n2;
        }
        return dependencies;
    }

    public static Set<IPackageFragmentRoot> detectJREPackageFragementRoots(IJavaProject javaProject) {
        HashSet<IPackageFragmentRoot> jreRoots = new HashSet<IPackageFragmentRoot>();
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().toString().contains("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                        if (!packageFragmentRoot.getPath().toFile().getParentFile().getName().equals("ext")) {
                            jreRoots.add(packageFragmentRoot);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_DETECT_PROJECT_JRE, (Throwable)e, (Object[])new Object[]{javaProject});
        }
        return jreRoots;
    }

    private synchronized void deregisterDependenciesForJavaProject(IJavaProject javaProject) {
        this.workspaceDependenciesByProject.removeAll((Object)javaProject);
        this.jrePackageFragmentRoots.removeAll((Object)javaProject);
        this.projectDependencyInfoCache.remove((Object)javaProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDependencyForJAR(JarPackageFragmentRoot root) {
        IJavaProject javaProject = (IJavaProject)this.getJavaProjectForPackageFragmentRoot((IPackageFragmentRoot)root).orNull();
        if (javaProject == null) {
            return;
        }
        EclipseDependencyListener eclipseDependencyListener = this;
        synchronized (eclipseDependencyListener) {
            DependencyInfo dependencyInfo;
            if (!this.isJREOfProjectKnown(javaProject)) {
                this.workspaceDependenciesByProject.removeAll((Object)javaProject);
                this.projectDependencyInfoCache.remove((Object)javaProject);
                this.registerDependenciesForJavaProject(javaProject);
            }
            if (!this.isPartOfTheJRE((IPackageFragmentRoot)root) && (dependencyInfo = (DependencyInfo)DependencyInfos.createJarDependencyInfo((IPackageFragmentRoot)root).orNull()) != null) {
                this.workspaceDependenciesByProject.put((Object)javaProject, (Object)dependencyInfo);
                this.cacheProjectDependencyInfo(javaProject);
            }
        }
    }

    private synchronized boolean isJREOfProjectKnown(IJavaProject javaProject) {
        for (DependencyInfo dependencyInfo : this.workspaceDependenciesByProject.get((Object)javaProject)) {
            if (dependencyInfo.getType() != DependencyType.JRE) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPartOfTheJRE(IPackageFragmentRoot pfr) {
        IJavaProject javaProject = (IJavaProject)this.getJavaProjectForPackageFragmentRoot(pfr).orNull();
        if (javaProject == null) {
            return false;
        }
        EclipseDependencyListener eclipseDependencyListener = this;
        synchronized (eclipseDependencyListener) {
            block5: {
                if (this.jrePackageFragmentRoots.containsEntry((Object)javaProject, (Object)pfr)) break block5;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDependencyForJAR(JarPackageFragmentRoot pfr) {
        IJavaProject javaProject = (IJavaProject)this.getJavaProjectForPackageFragmentRoot((IPackageFragmentRoot)pfr).orNull();
        if (javaProject == null) {
            return;
        }
        EclipseDependencyListener eclipseDependencyListener = this;
        synchronized (eclipseDependencyListener) {
            if (this.isPartOfTheJRE((IPackageFragmentRoot)pfr)) {
                this.deregisterJREDependenciesForProject(javaProject);
            } else {
                DependencyInfo jarDependencyInfo = (DependencyInfo)DependencyInfos.createJarDependencyInfo((IPackageFragmentRoot)pfr).orNull();
                if (jarDependencyInfo != null) {
                    this.workspaceDependenciesByProject.remove((Object)javaProject, (Object)jarDependencyInfo);
                }
                if (!this.workspaceDependenciesByProject.containsKey((Object)javaProject)) {
                    this.jrePackageFragmentRoots.removeAll((Object)javaProject);
                }
            }
        }
    }

    private synchronized void deregisterJREDependenciesForProject(IJavaProject javaProject) {
        for (DependencyInfo dependencyInfo : this.workspaceDependenciesByProject.get((Object)javaProject)) {
            if (dependencyInfo.getType() != DependencyType.JRE) continue;
            this.workspaceDependenciesByProject.remove((Object)javaProject, (Object)dependencyInfo);
            return;
        }
    }

    private Optional<IJavaProject> getJavaProjectForPackageFragmentRoot(IPackageFragmentRoot pfr) {
        IJavaProject parent = (IJavaProject)pfr.getAncestor(2);
        return Optional.fromNullable((Object)parent);
    }

    private synchronized void cacheProjectDependencyInfo(IJavaProject javaProject) {
        DependencyInfo dependencyInfo = (DependencyInfo)this.projectDependencyInfoCache.get((Object)javaProject);
        if (dependencyInfo != null) {
            return;
        }
        dependencyInfo = (DependencyInfo)DependencyInfos.createProjectDependencyInfo(javaProject).orNull();
        if (dependencyInfo == null) {
            return;
        }
        this.projectDependencyInfoCache.put((Object)javaProject, (Object)dependencyInfo);
    }

    public synchronized ImmutableSet<DependencyInfo> getDependencies() {
        ImmutableSet.Builder res = ImmutableSet.builder();
        for (IJavaProject javaProject : this.workspaceDependenciesByProject.keySet()) {
            Collection dependenciesForProject = this.workspaceDependenciesByProject.get((Object)javaProject);
            res.addAll((Iterable)dependenciesForProject);
        }
        return res.build();
    }

    public synchronized ImmutableSet<DependencyInfo> getDependenciesForProject(DependencyInfo project) {
        IJavaProject javaProject = (IJavaProject)this.projectDependencyInfoCache.inverse().get((Object)project);
        return ImmutableSet.copyOf((Collection)this.workspaceDependenciesByProject.get((Object)javaProject));
    }

    public synchronized ImmutableSet<DependencyInfo> getProjects() {
        return ImmutableSet.copyOf((Collection)this.projectDependencyInfoCache.inverse().keySet());
    }
}

