/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.text.MessageFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.recommenders.internal.models.rcp.ModelsRcpPreferences;
import org.eclipse.recommenders.internal.models.rcp.l10n.Messages;
import org.eclipse.recommenders.utils.Uris;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RepositoryDetailsDialog
extends TitleAreaDialog {
    private static final List<String> SUPPORTED_PROTOCOLS = ImmutableList.of((Object)"file", (Object)"http", (Object)"https");
    private Text repositoryUrlText;
    private Text repositoryUsernameText;
    private Text repositoryPasswordText;
    private String repositoryUrl;
    private final List<String> remoteUris;
    private final ModelsRcpPreferences preferences;

    public RepositoryDetailsDialog(Shell parentShell, String repositoryUrl, List<String> remoteUris, ModelsRcpPreferences preferences) {
        super(parentShell);
        this.repositoryUrl = repositoryUrl;
        this.remoteUris = remoteUris;
        this.preferences = preferences;
    }

    protected Control createDialogArea(Composite parent) {
        Composite fieldArea = new Composite((Composite)super.createDialogArea(parent), 0);
        boolean noRepository = this.repositoryUrl == null;
        String title = noRepository ? Messages.DIALOG_TITLE_ADD_MODEL_REPOSITORY : Messages.DIALOG_TITLE_EDIT_MODEL_REPOSITORY;
        this.getShell().setText(title);
        this.setTitle(title);
        this.setMessage(noRepository ? Messages.DIALOG_MESSAGE_ENTER_REPOSITORY_DETAILS : Messages.DIALOG_MESSAGE_EDIT_REPOSITORY_DETAILS);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(fieldArea);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fieldArea);
        this.repositoryUrlText = this.createLabelledText(fieldArea, Messages.DIALOG_LABEL_REPOSITORY_URL, noRepository ? "http://download.eclipse.org/recommenders/models/<version>" : this.repositoryUrl, 0);
        this.repositoryUsernameText = this.createLabelledText(fieldArea, Messages.DIALOG_LABEL_REPOSITORY_USERNAME, (String)this.preferences.getServerUsername(this.repositoryUrl).or((Object)""), 0);
        this.repositoryUsernameText.setMessage(Messages.DIALOG_HINT_OPTIONAL);
        this.repositoryPasswordText = this.createLabelledText(fieldArea, Messages.DIALOG_LABEL_REPOSITORY_PASSWORD, (String)this.preferences.getServerPassword(this.repositoryUrl).or((Object)""), 0x400000);
        this.repositoryPasswordText.setMessage(Messages.DIALOG_HINT_OPTIONAL);
        this.repositoryUrlText.addModifyListener((ModifyListener)new ServerRepositoryUrlListener(this.repositoryUsernameText, this.repositoryPasswordText));
        Dialog.applyDialogFont((Control)fieldArea);
        return fieldArea;
    }

    private Text createLabelledText(Composite parent, String labelText, String initialText, int additionalStyle) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        GridDataFactory.swtDefaults().applyTo((Control)label);
        Text text = new Text(parent, 0x800 | additionalStyle);
        text.setText(initialText);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RepositoryDetailsDialog.this.updatePageComplete();
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)text);
        return text;
    }

    private void updatePageComplete() {
        boolean hasError;
        block10: {
            block9: {
                URI uri;
                block8: {
                    block7: {
                        block6: {
                            this.setErrorMessage(null);
                            hasError = false;
                            try {
                                uri = (URI)Uris.parseURI((String)this.repositoryUrlText.getText()).orNull();
                                if (uri != null) break block6;
                                hasError = true;
                                this.setErrorMessage(Messages.DIALOG_MESSAGE_INVALID_URI);
                            }
                            catch (Throwable throwable) {
                                this.getButton(0).setEnabled(!hasError);
                                throw throwable;
                            }
                            this.getButton(0).setEnabled(!hasError);
                            return;
                        }
                        if (uri.isAbsolute()) break block7;
                        hasError = true;
                        this.setErrorMessage(Messages.DIALOG_MESSAGE_NOT_ABSOLUTE_URI);
                        this.getButton(0).setEnabled(!hasError);
                        return;
                    }
                    if (!this.isUriAlreadyAdded(uri)) break block8;
                    hasError = true;
                    this.setErrorMessage(Messages.DIALOG_MESSAGE_URI_ALREADY_ADDED);
                    this.getButton(0).setEnabled(!hasError);
                    return;
                }
                if (Uris.isUriProtocolSupported((URI)uri, SUPPORTED_PROTOCOLS)) break block9;
                hasError = true;
                this.setErrorMessage(MessageFormat.format(Messages.DIALOG_MESSAGE_UNSUPPORTED_PROTOCOL, uri.getScheme(), StringUtils.join(SUPPORTED_PROTOCOLS, (String)Messages.LIST_SEPARATOR)));
                this.getButton(0).setEnabled(!hasError);
                return;
            }
            if (this.isUsernameValid()) break block10;
            hasError = true;
            this.setErrorMessage(Messages.DIALOG_MESSAGE_PASSWORD_WITHOUT_USERNAME);
            this.getButton(0).setEnabled(!hasError);
            return;
        }
        this.getButton(0).setEnabled(!hasError);
    }

    private boolean isUriAlreadyAdded(URI uri) {
        URI repositoryUri;
        if (this.repositoryUrl != null && uri.equals(repositoryUri = (URI)Uris.parseURI((String)this.repositoryUrl).orNull())) {
            return false;
        }
        String mangledUri = Uris.mangle((URI)uri);
        for (String remoteUri : this.remoteUris) {
            if (!Uris.mangle((URI)Uris.toUri((String)remoteUri)).equals(mangledUri)) continue;
            return true;
        }
        return false;
    }

    private boolean isUsernameValid() {
        return !this.repositoryUsernameText.getText().isEmpty() || this.repositoryPasswordText.getText().isEmpty();
    }

    protected void okPressed() {
        this.repositoryUrl = this.repositoryUrlText.getText();
        this.preferences.setServerUsername(this.repositoryUrl, this.repositoryUsernameText.getText());
        this.preferences.setServerPassword(this.repositoryUrl, this.repositoryPasswordText.getText());
        super.okPressed();
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    private final class ServerRepositoryUrlListener
    implements ModifyListener {
        private final Text usernameField;
        private final Text passwordField;

        public ServerRepositoryUrlListener(Text usernameField, Text passwordField) {
            this.usernameField = usernameField;
            this.passwordField = passwordField;
        }

        public void modifyText(ModifyEvent e) {
            Text urlField = (Text)e.widget;
            String serverUri = urlField.getText();
            String username = (String)RepositoryDetailsDialog.this.preferences.getServerUsername(serverUri).orNull();
            if (username == null) {
                return;
            }
            this.usernameField.setText(username);
            String password = (String)RepositoryDetailsDialog.this.preferences.getServerPassword(serverUri).or((Object)"");
            this.passwordField.setText(password);
        }
    }
}

